package com.seatel.mobilehall.ui.home.activity

import android.Manifest
import android.app.Activity
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Bundle
import android.text.TextUtils
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.model.SeatelShopLocationModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.PermissionUtil
import com.google.android.gms.maps.CameraUpdateFactory
import com.google.android.gms.maps.GoogleMap
import com.google.android.gms.maps.OnMapReadyCallback
import com.google.android.gms.maps.model.BitmapDescriptorFactory
import com.google.android.gms.maps.model.CameraPosition
import com.google.android.gms.maps.model.LatLng
import com.google.android.gms.maps.model.MarkerOptions
import com.google.gson.Gson
import kotlinx.android.synthetic.main.activity_base.*
import kotlinx.android.synthetic.main.activity_contact_us.*

class ContactUsActivity : BaseActivity(), OnMapReadyCallback {

    private lateinit var shopData: SeatelShopLocationModel
    private var mPhoneNumberRequest: PermissionUtil.PermissionRequestObject? = null
    private var mMap: GoogleMap? = null
    private var mMapLatLong = LatLng(11.541889, 104.921333)

    override fun onMapReady(googleMap: GoogleMap?) {
        googleMap?.uiSettings!!.isScrollGesturesEnabled = false
        googleMap.uiSettings.isZoomControlsEnabled = false
        googleMap.uiSettings.isZoomGesturesEnabled = false
        displayMapMarker(googleMap)
    }

    private fun displayMapMarker(googleMap: GoogleMap?) {
        mMap = googleMap
        setMapLatLong()
    }

    private fun setMapLatLong() {
        if (mMap != null) {
            val mCameraPosition =
                CameraPosition.builder().target(mMapLatLong).zoom(17f).bearing(0.0f).tilt(0.0f)
                    .build()
            mMap!!.moveCamera(CameraUpdateFactory.newCameraPosition(mCameraPosition))
            val icon = BitmapDescriptorFactory.fromResource(R.drawable.ic_map_pin_white_bg)
            val markerOptions = MarkerOptions().icon(icon)
            mMap!!.addMarker(markerOptions.position(mMapLatLong))
        }
    }

    public override fun onResume() {
        super.onResume()
        map_contact_us.onResume()
    }

    public override fun onDestroy() {
        map_contact_us.onDestroy()
        super.onDestroy()
    }

    override fun onLowMemory() {
        map_contact_us.onLowMemory()
        super.onLowMemory()
    }

    public override fun onPause() {
        map_contact_us.onPause()
        super.onPause()
    }

    /*override fun onSaveInstanceState(outState: Bundle?) {
        super.onSaveInstanceState(outState)
        map_contact_us.onSaveInstanceState(outState)
    }
*/
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_contact_us)
        map_contact_us.onCreate(savedInstanceState)
        map_contact_us.getMapAsync(this)

        activityEnterRightAnimation()
        val data = intent.getStringExtra(Constant.SHOP_LOCATION_DATA)
        if (!TextUtils.isEmpty(data)) {
            shopData =
                Gson().fromJson<SeatelShopLocationModel>(data, SeatelShopLocationModel::class.java)
            if (shopData != null) {
                tv_head_office.text = shopData.name
                ctv_adress.text = shopData.address
                ctv_phone_number.text = shopData.contactNumber
                ctv_hour_work.text = shopData.hoursWork
                if (TextUtils.isEmpty(shopData.hoursWork)) {
                    ctv_hour_work.text = "N/A"
                }
                text_view_titleBar.text = shopData.name
                mMapLatLong = LatLng(shopData.latitude, shopData.longitude)
                setMapLatLong()
            }

            layout_center.setOnClickListener {
                showCallDialog()
            }

            btn_direction.setOnClickListener {
                val intent = Intent(
                    android.content.Intent.ACTION_VIEW,
                    Uri.parse("http://maps.google.com/maps?daddr=" + "${mMapLatLong.latitude},${mMapLatLong.longitude}")
                )
                startActivity(intent)
            }
        }

    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        mPhoneNumberRequest!!.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }

    private fun requestPermissionLocation() {
        mPhoneNumberRequest = PermissionUtil.with(this).request(Manifest.permission.CALL_PHONE)
            .onAllGranted(object : PermissionUtil.Func() {
                override fun call() {
                    showCallDialScreenPhone()
                }
            }).onAnyDenied(object : PermissionUtil.Func() {
            override fun call() {

            }
        }).askPermission(Constant.REQUEST_LOCATION_PERMISSION_CODE)
    }

    private fun showCallDialScreenPhone() {
        val intent = Intent(Intent.ACTION_DIAL)
        intent.data = Uri.parse("tel:${ctv_phone_number.text}")
        this.startActivity(intent)
    }

    private fun showCallDialog() {
        if (ContextCompat.checkSelfPermission(
                this,
                Manifest.permission.CALL_PHONE
            ) != PackageManager.PERMISSION_GRANTED
        ) {
            showCallDialScreenPhone()
        } else {
            requestPermissionLocation()
            ActivityCompat.requestPermissions(
                this as Activity,
                arrayOf(android.Manifest.permission.CALL_PHONE),
                Constant.REQUEST_PHONE_CALL
            )
        }
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.head_office)
    }

    companion object {
        fun lunch(context: Context, shopData: String) {
            val intent = Intent(context, ContactUsActivity::class.java)
            intent.putExtra(Constant.SHOP_LOCATION_DATA, shopData)
            context.startActivity(intent)
        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }


}
