package com.seatel.mobilehall.ui.home.viewholder

import android.content.Context
import android.text.TextUtils
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.adapter.MyOrderAdapter
import com.seatel.mobilehall.ui.home.interactor.MyOrderInteractor
import com.seatel.mobilehall.ui.home.model.MyOrderItemModel
import com.seatel.mobilehall.ui.home.model.MyOrderListModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import kotlinx.android.synthetic.main.item_bottom_ehub.view.*
import kotlinx.android.synthetic.main.item_my_order_header.view.*
import kotlinx.android.synthetic.main.item_my_order_mian_view.view.*

class OrderViewHolder(private var context: Context, itemView: View) :
    RecyclerView.ViewHolder(itemView) {
    fun bind(
        myCartModel: ArrayList<MyOrderItemModel>,
        mainData: MyOrderListModel,
        isHistory: Boolean = false,
        mView: MyOrderInteractor.View
    ) {
        val myCartAdapter = MyOrderAdapter(context, myCartModel)

        //Footer Total
        itemView.order_quantity.text = mainData.orderTotalQuantity.toString()
        val totalPrice = mainData.orderTotalPrice
        if (mainData.orderTotalShipmentInsurace != null && mainData.orderTotalShipmentInsurace!! > 0.0) {
//            if (totalPrice != null) {
//                totalPrice = totalPrice.plus(mainData.orderTotalShipmentInsurace!!)
//            }
            itemView.text_view_shipment_insurance.visibility = View.VISIBLE
            itemView.shipment_insurance_total.visibility = View.VISIBLE
            itemView.shipment_insurance_total.text =
                "${SeatelUtils.setFormatcurrency(mainData.orderTotalShipmentInsurace!!)}"
            itemView.text_view_shipment_insurance.text =
                "${context.getString(R.string.shipment_insurance)} (${OrderingManager.getInstance().shipmentInsuranceRate * 100}%)"
        } else {
            itemView.text_view_shipment_insurance.visibility = View.GONE
            itemView.shipment_insurance_total.visibility = View.GONE
        }
        itemView.grandTotal.text = "${SeatelUtils.setFormatcurrency(totalPrice)}"

        itemView.view_fotter_btn.visibility = View.VISIBLE
        itemView.status.visibility = View.VISIBLE
        itemView.status.text = SeatelUtils.toCamelCase(mainData.orderStatus?.replace("-", " "))
        itemView.img_delete.visibility = View.GONE
        if (isHistory) {
            itemView.view_fotter_btn.visibility = View.GONE
            itemView.img_delete.visibility = View.VISIBLE
            itemView.img_delete.setOnClickListener {
                mView.onDeletedOrderId(mainData.orderId.toString())
            }
//            itemView.status.visibility = View.GONE
        }
        //Header Order
        itemView.order_id.text = mainData.orderId.toString()
        itemView.order_date.text = SeatelUtils.getDateTime(
            "yyyy-MM-dd",
            Constant.DATE_FORMAT_DISPLAY_ORDER,
            mainData.orderDate
        )
        itemView.method_type.text =
            if (TextUtils.isEmpty(mainData.paymentMethod)) "N/A" else mainData.paymentMethod
        itemView.tran_id.text = if (TextUtils.isEmpty(mainData.tranId)) "N/A" else mainData.tranId

        itemView.recycler_view_order.adapter = myCartAdapter
        itemView.recycler_view_order.layoutManager = LinearLayoutManager(context)

        itemView.button_order_received.setOnClickListener {
            mView.onClickConfirmOrder(mainData.orderId.toString())
        }
    }
}