package com.seatel.mobilehall.util.view

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.RelativeLayout
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.manager.OrderingManager
import kotlinx.android.synthetic.main.view_order_bottom_bar.view.*
import java.util.*

class OrderBottomBarView @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0)
    : RelativeLayout(context, attrs, defStyleAttr) {
    private var onButtonClick: OnButtonClick? = null
    private var isClickAbleInsurance: Boolean = true
    private var isCheckInsurance: Boolean = false

    init {
        LayoutInflater.from(context).inflate(R.layout.view_order_bottom_bar, this)
        button_buy.setOnClickListener { onButtonClick?.onClick() }
        checkbox_insurance.setOnCheckedChangeListener { _, isChecked ->
            if (!isClickAbleInsurance) return@setOnCheckedChangeListener
            if (isChecked)
                view_check_insurance.alpha = 1f
            else view_check_insurance.alpha = 0.5f
            isCheckInsurance = isChecked
            onButtonClick?.onCheckShipInsurance(isChecked)
        }

        view_check_insurance.setOnClickListener {
            if (!isClickAbleInsurance) return@setOnClickListener
            checkbox_insurance.isChecked = !checkbox_insurance.isChecked
        }

        ctv_insurance_title.text = "${context.getString(R.string.shipment_insurance)} (${OrderingManager.getInstance().shipmentInsuranceRate * 100}%)"
        tv_term_condition.setOnClickListener {
            val uris = Uri.parse("${BuildConfig.BASE_URL}${Constant.urlTerm}")
            val intents = Intent(Intent.ACTION_VIEW, uris)
            val b = Bundle()
            b.putBoolean("new_window", true)
            intents.putExtras(b)
            context.startActivity(intents)
        }
    }

    fun isCheckInsurance(): Boolean {
        return isCheckInsurance
    }

    fun setOnButtonClick(onButtonClick: OnButtonClick) {
        this.onButtonClick = onButtonClick
    }

    fun setTotal(total: Double,itemSizeSelect: Int = 1) {
        text_view_total_price.text = String.format(Locale.US, "$%.2f", total)
        if (itemSizeSelect > 0 && total >= 0.0 || OrderingManager.getInstance().claimFreeSim || OrderingManager.getInstance().winPromotionFreeSim || OrderingManager.getInstance().skipTopUp)
            show()
        else hide()
    }

    fun setPriceInSurancePhoneDevice(price: Double) {
        ctv_price_insurance.text = String.format(Locale.US, "%.2f", price)
    }

    private fun hide() {
        animate().translationY(height.toFloat())
        postDelayed({ visibility = View.GONE }, 300)
    }

    private fun show() {
        visibility = View.VISIBLE
        animate().translationY(0f).duration = 300
    }

    fun hideShowButtonNext(isShow: Boolean) {
        button_buy.visibility = if (isShow) View.VISIBLE else View.GONE
    }

    fun hideInsuranceView(isShow: Boolean, unEditable: Boolean = false) {
        view_check_insurance.visibility = if (isShow) View.VISIBLE else View.GONE
        if (isShow) view_check_insurance.animate().translationY(0f).duration = 200
        else view_check_insurance.animate().translationY(50f).duration = 900
        checkbox_insurance.isClickable = !unEditable
        isClickAbleInsurance = !unEditable
    }

    fun setButtonText(id: Int) {
        setButtonText(context.getString(id))
    }

    fun setButtonText(string: String) {
        button_buy.text = string
    }

    interface OnButtonClick {
        fun onClick()
        fun onCheckShipInsurance(isCheck: Boolean)
    }
}