package com.seatel.mobilehall.ui.packages.fragment

import android.content.Context
import android.content.DialogInterface
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.util.Log
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.Toast
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import coil.load
import com.android.volley.NoConnectionError
import com.android.volley.Request
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.activity.ConfirmBuyDataPackActivity
import com.seatel.mobilehall.ui.home.activity.SuccessBuyDataPackActivity
import com.seatel.mobilehall.ui.home.adapter.AddOnAdapter
import com.seatel.mobilehall.ui.home.adapter.InternationalCallAdapter
import com.seatel.mobilehall.ui.home.adapter.LoyKobAddOnAdapter
import com.seatel.mobilehall.ui.home.adapter.ProductServiceDetailAdapter
import com.seatel.mobilehall.ui.home.adapter.TermAndServiceFooterAdapter
import com.seatel.mobilehall.ui.home.interactor.AppProductsInteractor
import com.seatel.mobilehall.ui.home.interactor.ProductServiceButtonClick
import com.seatel.mobilehall.ui.home.interactor.ProductServiceDetailInteractor
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel
import com.seatel.mobilehall.ui.home.model.CountryModel
import com.seatel.mobilehall.ui.home.model.MainDataModel
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.ui.home.presenter.AppProductsPresenter
import com.seatel.mobilehall.ui.home.presenter.ProductServiceDetailPrsenter
import com.seatel.mobilehall.ui.packages.adapter.OnePlanDetailAdapter
import com.seatel.mobilehall.ui.packages.adapter.ProductServicePackageAdapter
import com.seatel.mobilehall.ui.packages.adapter.RikReakDetailAdapter
import com.seatel.mobilehall.ui.packages.interactor.RikReayInteractor
import com.seatel.mobilehall.ui.packages.model.RikReayModel
import com.seatel.mobilehall.ui.packages.model.TableModel
import com.seatel.mobilehall.ui.packages.model.TableSubModel
import com.seatel.mobilehall.ui.packages.presenter.RikReayPresenter
import com.seatel.mobilehall.util.AnalyticsHelper
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView
import com.seatel.mobilehall.util.lang.LanguageManager
import kotlinx.android.synthetic.main.activity_product_service_detail.addon_frame
import kotlinx.android.synthetic.main.activity_product_service_detail.base_validity
import kotlinx.android.synthetic.main.activity_product_service_detail.btn_benefit
import kotlinx.android.synthetic.main.activity_product_service_detail.btn_data_header
import kotlinx.android.synthetic.main.activity_product_service_detail.btn_term_condition
import kotlinx.android.synthetic.main.activity_product_service_detail.call_sms
import kotlinx.android.synthetic.main.activity_product_service_detail.frame_benefit
import kotlinx.android.synthetic.main.activity_product_service_detail.frame_term_condition
import kotlinx.android.synthetic.main.activity_product_service_detail.mRecyclerAddOn
import kotlinx.android.synthetic.main.activity_product_service_detail.mRecyclerAddOnTermCondition
import kotlinx.android.synthetic.main.activity_product_service_detail.mRecyclerPackage
import kotlinx.android.synthetic.main.activity_product_service_detail.mRecyclerTermCondition
import kotlinx.android.synthetic.main.activity_product_service_detail.main_title
import kotlinx.android.synthetic.main.activity_product_service_detail.sub_title
import kotlinx.android.synthetic.main.activity_product_service_detail.tv_add_on_term_condition
import kotlinx.android.synthetic.main.fragment_package.btn_package
import kotlinx.android.synthetic.main.fragment_package.btn_plan
import kotlinx.android.synthetic.main.fragment_package.button_switch_plan
import kotlinx.android.synthetic.main.fragment_package.error_view
import kotlinx.android.synthetic.main.fragment_package.layout_international_call
import kotlinx.android.synthetic.main.fragment_package.layout_product_service_detail
import kotlinx.android.synthetic.main.fragment_package.mRecyclerCategory
import kotlinx.android.synthetic.main.fragment_package.mRecyclerOnePlan
import kotlinx.android.synthetic.main.fragment_package.mRecyclerRikReay
import kotlinx.android.synthetic.main.fragment_package.view_rik_reay
import kotlinx.android.synthetic.main.item_international_call_detail_activity.filter
import kotlinx.android.synthetic.main.item_international_call_detail_activity.img_international_call_detail
import kotlinx.android.synthetic.main.item_international_call_detail_activity.recycler_view_product_service
import kotlinx.android.synthetic.main.item_international_call_detail_activity.text_cents_min
import kotlinx.android.synthetic.main.item_product_service_detail.btn_data
import kotlinx.android.synthetic.main.layout_rik_reay.iv_header_banner
import kotlinx.android.synthetic.main.layout_rik_reay.iv_sub_header
import kotlinx.android.synthetic.main.layout_rik_reay.last_sub_title
import kotlinx.android.synthetic.main.layout_rik_reay.last_title
import kotlinx.android.synthetic.main.layout_rik_reay.mRecyclerTable
import kotlinx.android.synthetic.main.layout_rik_reay.mWebView
import kotlinx.android.synthetic.main.layout_rik_reay.tv_content_title
import kotlinx.android.synthetic.main.layout_rik_reay.tv_header_description
import kotlinx.android.synthetic.main.layout_rik_reay.tv_header_subTitle
import kotlinx.android.synthetic.main.layout_rik_reay.tv_header_title
import kotlinx.android.synthetic.main.layout_rik_reay.tv_sub_header_subTitle
import kotlinx.android.synthetic.main.layout_rik_reay.tv_table_title
import okhttp3.internal.indexOfFirstNonAsciiWhitespace
import org.json.JSONArray
import org.json.JSONObject

class PackageFragment : BaseFragment(), AppProductsInteractor.View,
    ProductServiceDetailInteractor.View, RikReayInteractor.View, ProductServiceButtonClick,
    View.OnClickListener {

    private lateinit var mAdapter: InternationalCallAdapter
    private var canSubscribe: Boolean = false
    private var canChangePlan: Boolean = false
    private var newPlanCode: String? = null
    private var switchPlanName: String? = null
    var lang: String = "en"
    var tableDataList = ArrayList<TableModel>()
    var tableDataListDisplay = ArrayList<TableModel>()
    var planCode: String? = null
    private var valueData: String? = null
    private var name: String? = null
    private var dataMainScreen: MainDataModel? = null
    private var shouldRefreshOnResume: Boolean = false


    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setFragmentLayout(R.layout.fragment_package)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        init()
    }

    override fun onPause() {
        super.onPause()
        shouldRefreshOnResume = true
    }

    override fun onResume() {
        super.onResume()
        if (shouldRefreshOnResume) {
            init()
        }
    }

    private fun init() {
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        AppProductsPresenter(requireContext(), this).onGetAppProducts(getPhoneLogin())
        btn_benefit.setOnClickListener(this)
        btn_term_condition.setOnClickListener(this)
        button_switch_plan.setOnClickListener(this)
    }

    private fun setupInternationalCall() {
        text_cents_min.text = getString(R.string.cents)
//        var strCent = text_cents_min.text
        mAdapter = InternationalCallAdapter(requireContext(), tableDataListDisplay)
        mAdapter.onFilterFinish = InternationalCallAdapter.OnFilter { _, content ->
            val viewHolder = recycler_view_product_service.findViewHolderForAdapterPosition(0)
            if (viewHolder != null) {
                val subAdapter = (viewHolder as InternationalCallAdapter.DetailViewHolder).mAdapter
                subAdapter.filter.filter(content)
            }

        }
        recycler_view_product_service.layoutManager =
            object : LinearLayoutManager(requireContext()) {
                override fun canScrollVertically(): Boolean {
                    return false
                }
            }
        recycler_view_product_service.setHasFixedSize(true)
        recycler_view_product_service.adapter = mAdapter
        if (LanguageManager.getInstance(requireContext()).getLanguageCode() != null) lang =
            LanguageManager.getInstance(requireContext()).getLanguageCode()!!.toLowerCase()/* when (lang) {
             Constant.KHMER -> {

                 Glide.with(this).load(R.drawable.banner_internationalcall_km)
                     .fitCenter()
                     .into(img_international_call_detail)
                 text_international_call.text = "អ្នកអាចតេទៅកាន់ពិភពលោកក្នុងតម្លៃចាប់ពី 3 សេន/នាទី!"
                 text_desc_international_call.text =
                     "អ្នកអាចតេទៅកាន់ពិភពលោកក្នុងតម្លៃចាប់ពី 3 សេន/នាទី!\n\n" +
                             "ដើម្បីតេ អ្នកគ្រាន់តែចុច 175 + លេខកូដប្រទេស + លេខទូរស័ព្ទ ឧទាហរណ៍ ប្រសិនបើអ្នកចង់តេទៅប្រទេសចិន គ្រាន់តែចុច 1758613980000000។\n\n" +
                             " ខាងក្រោមនេះជាតារាងឈ្មោះប្រទេស លេខកូដប្រទេស និងអត្រាតម្លៃ។"
             }
             Constant.CHINESE -> {
                 Glide.with(this).load(R.drawable.banner_internationalcall_en)
                     .fitCenter()
                     .into(img_international_call_detail)
                 text_international_call.text = "随时与世界通话，低至3美分一分钟。"
                 text_desc_international_call.text = "Yes, 现在您与世界通话，低至3美分一分钟。\n\n" +
                         "拨打国际长途，请加拨175+国际区号+电话号码。例如，您想拨打中国号码，请拨打1758613980000000。\n\n" +
                         "国际长途区号与资费请参考下表："
             }
             else -> Glide.with(this).load(R.drawable.banner_internationalcall_en)
                 .fitCenter()
                 .into(img_international_call_detail)
         }*/

        requireActivity().runOnUiThread {
            getTableData()
        }
    }

    private fun getTableData() {
        text_cents_min.text = getString(R.string.cents)
        val strCent = text_cents_min.text
        val tableDataSubList = ArrayList<TableSubModel>()
        val subData1 = TableSubModel(getString(R.string.china), "86")
        val subData2 = TableSubModel(getString(R.string.hong_kong_china), "852")
        val subData3 = TableSubModel(getString(R.string.malaysia), "60")
        val subData4 = TableSubModel(getString(R.string.singapore), "65")
        val subData5 = TableSubModel(getString(R.string.thailand), "66")
        tableDataSubList.add(subData1)
        tableDataSubList.add(subData2)
        tableDataSubList.add(subData3)
        tableDataSubList.add(subData4)
        tableDataSubList.add(subData5)
        val tableModel = TableModel("3 $strCent", tableDataSubList)

        //Data 7 Cents
        val tableDataSubList7cent = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.cents)
        val strCent1 = text_cents_min.text
        val subData7cent1 = TableSubModel(getString(R.string.american_samoa), "1")
        val subData7cent2 = TableSubModel(getString(R.string.bangladesh), "880")
        val subData7cent3 = TableSubModel(getString(R.string.canada), "1")
        val subData7cent4 = TableSubModel(getString(R.string.denmark), "45")
        val subData7cent5 = TableSubModel(getString(R.string.guam), "1")
        val subData7cent6 = TableSubModel(getString(R.string.hungary), "36")
        val subData7cent7 = TableSubModel(getString(R.string.iceland), "354")
        val subData7cent8 = TableSubModel(getString(R.string.india), "91")
        val subData7cent9 = TableSubModel(getString(R.string.malta_Mobile), "356")
        val subData7cent10 = TableSubModel(getString(R.string.mariana_islands), "1")
        val subData7cent11 = TableSubModel(getString(R.string.puerto_rico), "1")
        val subData7cent12 = TableSubModel(getString(R.string.romania), "40")
        val subData7cent13 = TableSubModel(getString(R.string.south_korea), "82")
        val subData7cent14 = TableSubModel(getString(R.string.sweden), "46")

        tableDataSubList7cent.add(subData7cent1)
        tableDataSubList7cent.add(subData7cent2)
        tableDataSubList7cent.add(subData7cent3)
        tableDataSubList7cent.add(subData7cent4)
        tableDataSubList7cent.add(subData7cent5)
        tableDataSubList7cent.add(subData7cent6)
        tableDataSubList7cent.add(subData7cent7)
        tableDataSubList7cent.add(subData7cent8)
        tableDataSubList7cent.add(subData7cent9)
        tableDataSubList7cent.add(subData7cent10)
        tableDataSubList7cent.add(subData7cent11)
        tableDataSubList7cent.add(subData7cent12)
        tableDataSubList7cent.add(subData7cent13)
        tableDataSubList7cent.add(subData7cent14)
        val tableModel1 = TableModel("7 $strCent1", tableDataSubList7cent)

        //Data 10 Cents
        val tableDataSubList10cent = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.cents)
        val strCent10 = text_cents_min.text
        val subData10cent1 = TableSubModel(getString(R.string.australia), "61")
        val subData10cent2 = TableSubModel(getString(R.string.australia_mobile_Satellite), "61")
        val subData10cent3 = TableSubModel(getString(R.string.bermuda), "1")
        val subData10cent4 = TableSubModel(getString(R.string.brunei), "673")
//        val subData10cent5 = TableSubModel(getString(R.string.cambodia), "855")
        val subData10cent6 = TableSubModel(getString(R.string.canada_Yukon_NW_Territories), "1")
        val subData10cent7 = TableSubModel(getString(R.string.costa_rica), "506")
        val subData10cent8 = TableSubModel(getString(R.string.czech_republic), "420")
        val subData10cent9 =
            TableSubModel(getString(R.string.france_mobile_globalstar_special_services), "33")
        val subData10cent10 = TableSubModel(getString(R.string.french_guiana), "594")
        val subData10cent11 = TableSubModel(getString(R.string.greece), "30")
        val subData10cent12 = TableSubModel(getString(R.string.guadeloupe), "590")
        val subData10cent13 = TableSubModel(getString(R.string.indonesia), "62")
        val subData10cent14 = TableSubModel(getString(R.string.japan), "81")
        val subData10cent15 = TableSubModel(getString(R.string.kazakhstan_other_OLO), "7")
        val subData10cent16 = TableSubModel(getString(R.string.macau), "853")
        val subData10cent17 = TableSubModel(getString(R.string.martinique), "596")
        val subData10cent18 = TableSubModel(getString(R.string.mayotte), "262")
        val subData10cent19 = TableSubModel(getString(R.string.mexico), "52")
        val subData10cent20 = TableSubModel(getString(R.string.mongolia), "976")
        val subData10cent21 = TableSubModel(getString(R.string.namibia), "264")
        val subData10cent22 = TableSubModel(getString(R.string.new_zealand), "64")
        val subData10cent23 = TableSubModel(getString(R.string.nigeria_mobile), "234")
        val subData10cent24 = TableSubModel(getString(R.string.pakistan), "92")
        val subData10cent25 = TableSubModel(getString(R.string.reunion_island_mobile), "262")
        val subData10cent26 = TableSubModel(getString(R.string.russia_moscow_central), "7")
        val subData10cent27 = TableSubModel(getString(R.string.russia_other), "7")
        val subData10cent28 = TableSubModel(getString(R.string.russia_st_petersburg), "7")
        val subData10cent30 = TableSubModel(getString(R.string.universal_disaster_relief), "888")
        val subData10cent31 = TableSubModel(getString(R.string.usa_lata), "1")
        val subData10cent32 = TableSubModel(getString(R.string.usa_other_mainland), "1")
        val subData10cent33 = TableSubModel(getString(R.string.uzbekistan), "998")
        val subData10cent34 = TableSubModel(getString(R.string.vietnam), "84")

        tableDataSubList10cent.add(subData10cent1)
        tableDataSubList10cent.add(subData10cent2)
        tableDataSubList10cent.add(subData10cent3)
        tableDataSubList10cent.add(subData10cent4)
//        tableDataSubList10cent.add(subData10cent5)
        tableDataSubList10cent.add(subData10cent6)
        tableDataSubList10cent.add(subData10cent7)
        tableDataSubList10cent.add(subData10cent8)
        tableDataSubList10cent.add(subData10cent9)
        tableDataSubList10cent.add(subData10cent10)
        tableDataSubList10cent.add(subData10cent11)
        tableDataSubList10cent.add(subData10cent12)
        tableDataSubList10cent.add(subData10cent13)
        tableDataSubList10cent.add(subData10cent14)
        tableDataSubList10cent.add(subData10cent15)
        tableDataSubList10cent.add(subData10cent16)
        tableDataSubList10cent.add(subData10cent17)
        tableDataSubList10cent.add(subData10cent18)
        tableDataSubList10cent.add(subData10cent19)
        tableDataSubList10cent.add(subData10cent20)
        tableDataSubList10cent.add(subData10cent21)
        tableDataSubList10cent.add(subData10cent22)
        tableDataSubList10cent.add(subData10cent23)
        tableDataSubList10cent.add(subData10cent24)
        tableDataSubList10cent.add(subData10cent25)
        tableDataSubList10cent.add(subData10cent26)
        tableDataSubList10cent.add(subData10cent27)
        tableDataSubList10cent.add(subData10cent28)
        tableDataSubList10cent.add(subData10cent30)
        tableDataSubList10cent.add(subData10cent31)
        tableDataSubList10cent.add(subData10cent32)
        tableDataSubList10cent.add(subData10cent33)
        tableDataSubList10cent.add(subData10cent34)
        val tableModel2 = TableModel("10 $strCent10", tableDataSubList10cent)

        //Data 15 Cents
        val tableDataSubList15cent = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.cents)
        val strCent15 = text_cents_min.text
        val subData15cent1 = TableSubModel(getString(R.string.angola), "224")
        val subData15cent2 = TableSubModel(getString(R.string.argentina), "54")
        val subData15cent3 = TableSubModel(getString(R.string.bahrain), "973")
        val subData15cent4 = TableSubModel(getString(R.string.bhutan), "975")
        val subData15cent5 = TableSubModel(getString(R.string.cyprus), "357")
        val subData15cent6 = TableSubModel(getString(R.string.dominican_republic), "1")
        val subData15cent7 = TableSubModel(getString(R.string.egypt), "20")
        val subData15cent8 = TableSubModel(getString(R.string.ireland), "353")
        val subData15cent9 = TableSubModel(getString(R.string.kuwait_mobile), "965")
        val subData15cent10 = TableSubModel(getString(R.string.laos), "856")
        val subData15cent11 =
            TableSubModel(getString(R.string.liechtenstein_special_services), "423")
        val subData15cent12 = TableSubModel(getString(R.string.luxembourg), "352")
        val subData15cent13 = TableSubModel(getString(R.string.nepal), "977")
        val subData15cent14 = TableSubModel(getString(R.string.paraguay), "595")
        val subData15cent15 = TableSubModel(getString(R.string.reunion_island_mobile), "262")
        val subData15cent16 = TableSubModel(getString(R.string.saudi_arabia), "966")
        val subData15cent17 = TableSubModel(getString(R.string.slovakia), "421")
        val subData15cent18 = TableSubModel(getString(R.string.st_maarten), "1721")
        val subData15cent19 = TableSubModel(getString(R.string.taiwan), "886")
        val subData15cent20 = TableSubModel(getString(R.string.venezuela), "58")

        tableDataSubList15cent.add(subData15cent1)
        tableDataSubList15cent.add(subData15cent2)
        tableDataSubList15cent.add(subData15cent3)
        tableDataSubList15cent.add(subData15cent4)
        tableDataSubList15cent.add(subData15cent5)
        tableDataSubList15cent.add(subData15cent6)
        tableDataSubList15cent.add(subData15cent7)
        tableDataSubList15cent.add(subData15cent8)
        tableDataSubList15cent.add(subData15cent9)
        tableDataSubList15cent.add(subData15cent10)
        tableDataSubList15cent.add(subData15cent11)
        tableDataSubList15cent.add(subData15cent12)
        tableDataSubList15cent.add(subData15cent13)
        tableDataSubList15cent.add(subData15cent14)
        tableDataSubList15cent.add(subData15cent15)
        tableDataSubList15cent.add(subData15cent16)
        tableDataSubList15cent.add(subData15cent17)
        tableDataSubList15cent.add(subData15cent18)
        tableDataSubList15cent.add(subData15cent19)
        tableDataSubList15cent.add(subData15cent20)
        val tableModel5 = TableModel("15 $strCent15", tableDataSubList15cent)
        //Data 25 Cents
        val tableDataSubList25cent = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.cents)
        var strCent25 = text_cents_min.text
        val subData25cent1 = TableSubModel(getString(R.string.iran), "98")
        val subData25cent2 = TableSubModel(getString(R.string.jordan), "962")
        val subData25cent3 = TableSubModel(getString(R.string.norway), "47")
        val subData25cent4 = TableSubModel(getString(R.string.south_africa), "27")
        val subData25cent5 = TableSubModel(getString(R.string.abkhazia), "7")
        val subData25cent6 = TableSubModel(getString(R.string.afghanistan), "93")
        val subData25cent7 = TableSubModel(getString(R.string.andorra), "376")
        val subData25cent8 = TableSubModel(getString(R.string.aruba), "297")
        val subData25cent9 = TableSubModel(getString(R.string.bahamas), "1")
        val subData25cent10 = TableSubModel(getString(R.string.bolivia), "591")
        val subData25cent11 = TableSubModel(getString(R.string.cayman_islands), "1")
        val subData25cent12 = TableSubModel(getString(R.string.colombia), "57")
        val subData25cent13 = TableSubModel(getString(R.string.ecuador), "593")
        val subData25cent14 = TableSubModel(getString(R.string.el_salvador), "503")
        val subData25cent15 = TableSubModel(getString(R.string.faroe_islands), "298")
        val subData25cent16 = TableSubModel(getString(R.string.ghana), "233")
        val subData25cent17 = TableSubModel(getString(R.string.gibraltar), "350")
        val subData25cent18 = TableSubModel(getString(R.string.guatemala), "502")
        val subData25cent19 = TableSubModel(getString(R.string.honduras), "504")
        val subData25cent20 = TableSubModel(getString(R.string.iraq), "964")
        val subData25cent21 = TableSubModel(getString(R.string.israel), "972")
        val subData25cent22 = TableSubModel(getString(R.string.kyrgyzstan), "996")
        val subData25cent23 = TableSubModel(getString(R.string.lebanon), "961")
        val subData25cent24 = TableSubModel(getString(R.string.marshall_islands), "692")
        val subData25cent25 = TableSubModel(getString(R.string.netherlands_antilles), "599")
        val subData25cent26 = TableSubModel(getString(R.string.new_caledonia), "687")
        val subData25cent27 = TableSubModel(getString(R.string.palestine), "970")
        val subData25cent28 = TableSubModel(getString(R.string.panama), "507")
        val subData25cent29 = TableSubModel(getString(R.string.philippines), "63")
        val subData25cent30 = TableSubModel(getString(R.string.qatar), "974")
        val subData25cent31 = TableSubModel(getString(R.string.rusia_other1), "7")
        val subData25cent32 = TableSubModel(getString(R.string.spain), "34")
        val subData25cent33 = TableSubModel(getString(R.string.sri_lanka), "94")
        val subData25cent34 = TableSubModel(getString(R.string.sudan), "249")
        val subData25cent35 = TableSubModel(getString(R.string.swaziland), "268")
        val subData25cent36 = TableSubModel(getString(R.string.syria), "963")
        val subData25cent37 = TableSubModel(getString(R.string.tadjikistan), "992")
        val subData25cent38 = TableSubModel(getString(R.string.trinidad_tobago), "1")
        val subData25cent39 = TableSubModel(getString(R.string.turkey), "90")
        val subData25cent40 = TableSubModel(getString(R.string.turkmenistan), "993")
        val subData25cent41 = TableSubModel(getString(R.string.universal_disaster_relief), "888")
        val subData25cent42 = TableSubModel(getString(R.string.uruguay_mobile), "598")
        val subData25cent43 = TableSubModel(getString(R.string.yemen), "967")
        val subData25cent44 = TableSubModel(getString(R.string.zambia_mobile), "260")


        tableDataSubList25cent.add(subData25cent1)
        tableDataSubList25cent.add(subData25cent2)
        tableDataSubList25cent.add(subData25cent3)
        tableDataSubList25cent.add(subData25cent4)
        tableDataSubList25cent.add(subData25cent5)
        tableDataSubList25cent.add(subData25cent6)
        tableDataSubList25cent.add(subData25cent7)
        tableDataSubList25cent.add(subData25cent8)
        tableDataSubList25cent.add(subData25cent9)
        tableDataSubList25cent.add(subData25cent10)
        tableDataSubList25cent.add(subData25cent11)
        tableDataSubList25cent.add(subData25cent12)
        tableDataSubList25cent.add(subData25cent13)
        tableDataSubList25cent.add(subData25cent14)
        tableDataSubList25cent.add(subData25cent15)
        tableDataSubList25cent.add(subData25cent16)
        tableDataSubList25cent.add(subData25cent17)
        tableDataSubList25cent.add(subData25cent18)
        tableDataSubList25cent.add(subData25cent19)
        tableDataSubList25cent.add(subData25cent20)
        tableDataSubList25cent.add(subData25cent21)
        tableDataSubList25cent.add(subData25cent22)
        tableDataSubList25cent.add(subData25cent23)
        tableDataSubList25cent.add(subData25cent24)
        tableDataSubList25cent.add(subData25cent25)
        tableDataSubList25cent.add(subData25cent26)
        tableDataSubList25cent.add(subData25cent27)
        tableDataSubList25cent.add(subData25cent28)
        tableDataSubList25cent.add(subData25cent29)
        tableDataSubList25cent.add(subData25cent30)
        tableDataSubList25cent.add(subData25cent31)
        tableDataSubList25cent.add(subData25cent31)
        tableDataSubList25cent.add(subData25cent32)
        tableDataSubList25cent.add(subData25cent33)
        tableDataSubList25cent.add(subData25cent34)
        tableDataSubList25cent.add(subData25cent35)
        tableDataSubList25cent.add(subData25cent36)
        tableDataSubList25cent.add(subData25cent37)
        tableDataSubList25cent.add(subData25cent38)
        tableDataSubList25cent.add(subData25cent39)
        tableDataSubList25cent.add(subData25cent40)
        tableDataSubList25cent.add(subData25cent41)
        tableDataSubList25cent.add(subData25cent42)
        tableDataSubList25cent.add(subData25cent43)
        tableDataSubList25cent.add(subData25cent44)

        val tableMode25 = TableModel("25 $strCent25", tableDataSubList25cent)

        //Data 30 Cents
        val tableDataSubList30cent = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.cents)
        var strCent30 = text_cents_min.text
        val subData30cent1 = TableSubModel(getString(R.string.antigua_barbuda), "1")
        val subData30cent2 = TableSubModel(getString(R.string.armenia), "374")
        val subData30cent3 = TableSubModel(getString(R.string.austria), "43")
        val subData30cent4 = TableSubModel(getString(R.string.austria), "43")
        val subData30cent5 = TableSubModel(getString(R.string.belize), "501")
        val subData30cent6 = TableSubModel(getString(R.string.botswana), "267")
        val subData30cent7 = TableSubModel(getString(R.string.brazil), "55")
        val subData30cent8 = TableSubModel(getString(R.string.british_virgin_islands), "1")
        val subData30cent9 = TableSubModel(getString(R.string.dominica), "1")
        val subData30cent10 = TableSubModel(getString(R.string.eritrea), "291")
        val subData30cent11 = TableSubModel(getString(R.string.ethiopia), "251")
        val subData30cent12 = TableSubModel(getString(R.string.georgia), "995")
        val subData30cent13 = TableSubModel(getString(R.string.germany), "49")
        val subData30cent14 = TableSubModel(getString(R.string.guyana), "592")
        val subData30cent15 = TableSubModel(getString(R.string.italy), "39")
        val subData30cent16 = TableSubModel(getString(R.string.jamaica), "1")
        val subData30cent17 = TableSubModel(getString(R.string.kenya), "254")
        val subData30cent18 = TableSubModel(getString(R.string.libya), "254")
        val subData30cent19 = TableSubModel(getString(R.string.montserrat), "1")
        val subData30cent20 = TableSubModel(getString(R.string.myanmar), "95")
        val subData30cent21 = TableSubModel(getString(R.string.netherlands), "31")
        val subData30cent22 = TableSubModel(getString(R.string.nicaragua), "505")
        val subData30cent23 = TableSubModel(getString(R.string.oman), "968")
        val subData30cent24 = TableSubModel(getString(R.string.san_marino), "378")
        val subData30cent25 = TableSubModel(getString(R.string.st_kitts_nevis), "1")
        val subData30cent26 = TableSubModel(getString(R.string.st_lucia), "1")
        val subData30cent27 = TableSubModel(getString(R.string.st_pierre_miquelon), "508")
        val subData30cent28 = TableSubModel(getString(R.string.st_vincent_grenadines), "1")
        val subData30cent29 = TableSubModel(getString(R.string.turks_caicos_islands), "1")
        val subData30cent30 = TableSubModel(getString(R.string.ukraine), "380")
        val subData30cent31 = TableSubModel(getString(R.string.united_arab_emirates), "44")
        val subData30cent32 = TableSubModel(getString(R.string.wallis_futuna), "681")
        tableDataSubList30cent.add(subData30cent1)
        tableDataSubList30cent.add(subData30cent2)
        tableDataSubList30cent.add(subData30cent3)
        tableDataSubList30cent.add(subData30cent4)
        tableDataSubList30cent.add(subData30cent5)
        tableDataSubList30cent.add(subData30cent6)
        tableDataSubList30cent.add(subData30cent7)
        tableDataSubList30cent.add(subData30cent8)
        tableDataSubList30cent.add(subData30cent9)
        tableDataSubList30cent.add(subData30cent10)
        tableDataSubList30cent.add(subData30cent11)
        tableDataSubList30cent.add(subData30cent12)
        tableDataSubList30cent.add(subData30cent13)
        tableDataSubList30cent.add(subData30cent14)
        tableDataSubList30cent.add(subData30cent15)
        tableDataSubList30cent.add(subData30cent16)
        tableDataSubList30cent.add(subData30cent17)
        tableDataSubList30cent.add(subData30cent18)
        tableDataSubList30cent.add(subData30cent19)
        tableDataSubList30cent.add(subData30cent20)
        tableDataSubList30cent.add(subData30cent21)
        tableDataSubList30cent.add(subData30cent22)
        tableDataSubList30cent.add(subData30cent23)
        tableDataSubList30cent.add(subData30cent24)
        tableDataSubList30cent.add(subData30cent25)
        tableDataSubList30cent.add(subData30cent26)
        tableDataSubList30cent.add(subData30cent27)
        tableDataSubList30cent.add(subData30cent28)
        tableDataSubList30cent.add(subData30cent29)
        tableDataSubList30cent.add(subData30cent30)
        tableDataSubList30cent.add(subData30cent31)
        tableDataSubList30cent.add(subData30cent32)
        val tableMode30 = TableModel("30 $strCent30", tableDataSubList30cent)

        //Data 50 Cents
        val tableDataSubList50cent = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.cents)
        val strCent50 = text_cents_min.text
        val subData50cent1 = TableSubModel(getString(R.string.albania), "355")
        val subData50cent2 = TableSubModel(getString(R.string.algeria), "213")
        val subData50cent3 = TableSubModel(getString(R.string.anguilla), "1")
        val subData50cent4 = TableSubModel(getString(R.string.austria_toll_shared), "43")
        val subData50cent5 = TableSubModel(getString(R.string.azerbaijan), "994")
        val subData50cent6 = TableSubModel(getString(R.string.belarus), "375")
        val subData50cent7 = TableSubModel(getString(R.string.belgium), "32")
        val subData50cent8 = TableSubModel(getString(R.string.benin), "229")
        val subData50cent9 = TableSubModel(getString(R.string.bosnia_herzegovina), "387")
        val subData50cent10 = TableSubModel(getString(R.string.bulgaria), "359")
        val subData50cent11 = TableSubModel(getString(R.string.burkina_faso), "226")
        val subData50cent12 = TableSubModel(getString(R.string.burundi), "257")
        val subData50cent13 = TableSubModel(getString(R.string.cape_verde), "238")
        val subData50cent14 = TableSubModel(getString(R.string.comoros), "269")
        val subData50cent15 = TableSubModel(getString(R.string.congo), "242")
        val subData50cent16 = TableSubModel(getString(R.string.croatia), "385")
        val subData50cent17 = TableSubModel(getString(R.string.dem_rep), "243")
        val subData50cent18 = TableSubModel(getString(R.string.djibouti), "253")
        val subData50cent19 = TableSubModel(getString(R.string.equatorial_guinea), "240")
        val subData50cent20 = TableSubModel(getString(R.string.estonia_special_services), "372")
        val subData50cent21 = TableSubModel(getString(R.string.fiji), "679")
        val subData50cent22 = TableSubModel(getString(R.string.finland), "358")
        val subData50cent23 = TableSubModel(getString(R.string.france), "33")
        val subData50cent24 = TableSubModel(getString(R.string.french_polynesia), "689")
        val subData50cent25 = TableSubModel(getString(R.string.grenada), "1")
        val subData50cent26 = TableSubModel(getString(R.string.guinea), "224")
        val subData50cent27 = TableSubModel(getString(R.string.guinea_bissau), "245")
        val subData50cent28 = TableSubModel(getString(R.string.haiti), "509")
        val subData50cent29 = TableSubModel(getString(R.string.pivory_coast), "225")
        val subData50cent30 = TableSubModel(getString(R.string.lesotho), "266")
        val subData50cent31 = TableSubModel(getString(R.string.liberia), "231")
        val subData50cent32 = TableSubModel(getString(R.string.macedonia), "389")
        val subData50cent33 = TableSubModel(getString(R.string.malawi), "265")
        val subData50cent34 = TableSubModel(getString(R.string.mali), "223")
        val subData50cent35 = TableSubModel(getString(R.string.micronesia), "691")
        val subData50cent36 = TableSubModel(getString(R.string.moldova), "373")
        val subData50cent37 = TableSubModel(getString(R.string.monaco), "377")
        val subData50cent38 = TableSubModel(getString(R.string.montenegro), "382")
        val subData50cent39 = TableSubModel(getString(R.string.morocco), "212")
        val subData50cent40 = TableSubModel(getString(R.string.mozambique), "258")
        val subData50cent41 = TableSubModel(getString(R.string.niger), "227")
        val subData50cent42 = TableSubModel(getString(R.string.niger_special_services), "227")
        val subData50cent43 = TableSubModel(getString(R.string.peru), "51")
        val subData50cent44 = TableSubModel(getString(R.string.portugal), "351")
        val subData50cent45 = TableSubModel(getString(R.string.rwanda), "351")
        val subData50cent46 = TableSubModel(getString(R.string.senegal), "221")
        val subData50cent47 = TableSubModel(getString(R.string.serbia), "221")
        val subData50cent48 = TableSubModel(getString(R.string.slovenia), "386")
        val subData50cent49 = TableSubModel(getString(R.string.south_sfrica_special_services), "27")
        val subData50cent50 = TableSubModel(getString(R.string.south_sudan), "221")
        val subData50cent51 = TableSubModel(getString(R.string.swaziland), "41")
        val subData50cent52 = TableSubModel(getString(R.string.tanzania), "255")
        val subData50cent53 = TableSubModel(getString(R.string.togo), "228")
        val subData50cent54 = TableSubModel(getString(R.string.uganda), "256")
        val subData50cent55 = TableSubModel(getString(R.string.zimbabwe), "263")

        tableDataSubList50cent.add(subData50cent1)
        tableDataSubList50cent.add(subData50cent2)
        tableDataSubList50cent.add(subData50cent3)
        tableDataSubList50cent.add(subData50cent4)
        tableDataSubList50cent.add(subData50cent5)
        tableDataSubList50cent.add(subData50cent6)
        tableDataSubList50cent.add(subData50cent7)
        tableDataSubList50cent.add(subData50cent8)
        tableDataSubList50cent.add(subData50cent9)
        tableDataSubList50cent.add(subData50cent10)
        tableDataSubList50cent.add(subData50cent11)
        tableDataSubList50cent.add(subData50cent12)
        tableDataSubList50cent.add(subData50cent13)
        tableDataSubList50cent.add(subData50cent14)
        tableDataSubList50cent.add(subData50cent15)
        tableDataSubList50cent.add(subData50cent16)
        tableDataSubList50cent.add(subData50cent17)
        tableDataSubList50cent.add(subData50cent18)
        tableDataSubList50cent.add(subData50cent19)
        tableDataSubList50cent.add(subData50cent20)
        tableDataSubList50cent.add(subData50cent21)
        tableDataSubList50cent.add(subData50cent22)
        tableDataSubList50cent.add(subData50cent23)
        tableDataSubList50cent.add(subData50cent24)
        tableDataSubList50cent.add(subData50cent25)
        tableDataSubList50cent.add(subData50cent26)
        tableDataSubList50cent.add(subData50cent27)
        tableDataSubList50cent.add(subData50cent28)
        tableDataSubList50cent.add(subData50cent29)
        tableDataSubList50cent.add(subData50cent30)
        tableDataSubList50cent.add(subData50cent31)
        tableDataSubList50cent.add(subData50cent32)
        tableDataSubList50cent.add(subData50cent33)
        tableDataSubList50cent.add(subData50cent34)
        tableDataSubList50cent.add(subData50cent35)
        tableDataSubList50cent.add(subData50cent36)
        tableDataSubList50cent.add(subData50cent37)
        tableDataSubList50cent.add(subData50cent38)
        tableDataSubList50cent.add(subData50cent39)
        tableDataSubList50cent.add(subData50cent40)
        tableDataSubList50cent.add(subData50cent41)
        tableDataSubList50cent.add(subData50cent42)
        tableDataSubList50cent.add(subData50cent43)
        tableDataSubList50cent.add(subData50cent44)
        tableDataSubList50cent.add(subData50cent45)
        tableDataSubList50cent.add(subData50cent46)
        tableDataSubList50cent.add(subData50cent47)
        tableDataSubList50cent.add(subData50cent48)
        tableDataSubList50cent.add(subData50cent49)
        tableDataSubList50cent.add(subData50cent50)
        tableDataSubList50cent.add(subData50cent51)
        tableDataSubList50cent.add(subData50cent52)
        tableDataSubList50cent.add(subData50cent53)
        tableDataSubList50cent.add(subData50cent54)
        tableDataSubList50cent.add(subData50cent55)
        val tableMode50 = TableModel("50 $strCent50", tableDataSubList50cent)

        //Data 1$
        val tableDataSubList1dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        var strCent1Dollar = text_cents_min.text
        val subData1dollar1 = TableSubModel(getString(R.string.cameroon), "237")
        val subData1dollar2 = TableSubModel(getString(R.string.central_african_republic), "236")
        val subData1dollar3 = TableSubModel(getString(R.string.chad), "235")
        val subData1dollar4 = TableSubModel(getString(R.string.chile), "56")
        val subData1dollar5 = TableSubModel(getString(R.string.cook_islands), "682")
        val subData1dollar6 = TableSubModel(getString(R.string.cuba), "53")
        val subData1dollar7 = TableSubModel(getString(R.string.east_timor), "670")
        val subData1dollar8 = TableSubModel(getString(R.string.estonia), "372")
        val subData1dollar9 = TableSubModel(getString(R.string.gabon), "241")
        val subData1dollar10 = TableSubModel(getString(R.string.gambia), "220")
        val subData1dollar11 = TableSubModel(getString(R.string.greenland), "299")
        val subData1dollar12 = TableSubModel(getString(R.string.kazakhstan), "7")
        val subData1dollar13 = TableSubModel(getString(R.string.latvia), "371")
        val subData1dollar14 = TableSubModel(getString(R.string.lithuania), "370")
        val subData1dollar15 = TableSubModel(getString(R.string.mauritania), "222")
        val subData1dollar16 = TableSubModel(getString(R.string.north_korea), "850")
        val subData1dollar17 = TableSubModel(getString(R.string.palau), "680")
        val subData1dollar18 = TableSubModel(getString(R.string.papua_new_guinea), "675")
        val subData1dollar19 = TableSubModel(getString(R.string.poland), "48")
        val subData1dollar20 = TableSubModel(getString(R.string.san_marino_special_services), "378")
        val subData1dollar21 = TableSubModel(getString(R.string.seychelles), "248")
        val subData1dollar22 = TableSubModel(getString(R.string.sierra_leone), "232")
        val subData1dollar23 = TableSubModel(getString(R.string.somalia), "252")
        val subData1dollar24 =
            TableSubModel(getString(R.string.south_sfrica_special_services), "27")
        val subData1dollar25 = TableSubModel(getString(R.string.suriname), "579")
        val subData1dollar26 = TableSubModel(getString(R.string.tonga), "579")
        val subData1dollar27 = TableSubModel(getString(R.string.tunisia), "216")
        val subData1dollar28 = TableSubModel(getString(R.string.universal_personal_TPG), "878")
        val subData1dollar29 = TableSubModel(getString(R.string.vanuatu), "678")
        val subData1dollar30 = TableSubModel(getString(R.string.western_samoa), "685")
        tableDataSubList1dollar.add(subData1dollar1)
        tableDataSubList1dollar.add(subData1dollar2)
        tableDataSubList1dollar.add(subData1dollar3)
        tableDataSubList1dollar.add(subData1dollar4)
        tableDataSubList1dollar.add(subData1dollar5)
        tableDataSubList1dollar.add(subData1dollar6)
        tableDataSubList1dollar.add(subData1dollar7)
        tableDataSubList1dollar.add(subData1dollar8)
        tableDataSubList1dollar.add(subData1dollar9)
        tableDataSubList1dollar.add(subData1dollar10)
        tableDataSubList1dollar.add(subData1dollar11)
        tableDataSubList1dollar.add(subData1dollar12)
        tableDataSubList1dollar.add(subData1dollar13)
        tableDataSubList1dollar.add(subData1dollar14)
        tableDataSubList1dollar.add(subData1dollar15)
        tableDataSubList1dollar.add(subData1dollar16)
        tableDataSubList1dollar.add(subData1dollar17)
        tableDataSubList1dollar.add(subData1dollar18)
        tableDataSubList1dollar.add(subData1dollar19)
        tableDataSubList1dollar.add(subData1dollar20)
        tableDataSubList1dollar.add(subData1dollar21)
        tableDataSubList1dollar.add(subData1dollar22)
        tableDataSubList1dollar.add(subData1dollar23)
        tableDataSubList1dollar.add(subData1dollar24)
        tableDataSubList1dollar.add(subData1dollar25)
        tableDataSubList1dollar.add(subData1dollar26)
        tableDataSubList1dollar.add(subData1dollar27)
        tableDataSubList1dollar.add(subData1dollar28)
        tableDataSubList1dollar.add(subData1dollar29)
        tableDataSubList1dollar.add(subData1dollar30)

        val tableMode1dollar = TableModel("1 $strCent1Dollar", tableDataSubList1dollar)
        //Data 1.5$
        val tableDataSubList1dollar5cents = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        var str1Dollar5Cent = text_cents_min.text
        val subData1dollar5cents1 = TableSubModel(getString(R.string.antarctica), "6721")
        val subData1dollar5cents2 = TableSubModel(getString(R.string.ascension_island), "247")
        val subData1dollar5cents3 = TableSubModel(getString(R.string.australia_territories), "6723")
        val subData1dollar5cents4 = TableSubModel(getString(R.string.barbados), "1")
        val subData1dollar5cents5 =
            TableSubModel(getString(R.string.belarus_special_services), "375")
        val subData1dollar5cents6 =
            TableSubModel(getString(R.string.cameroon_special_services), "237")
        val subData1dollar5cents7 =
            TableSubModel(getString(R.string.comoros_special_services), "269")
        val subData1dollar5cents8 = TableSubModel(getString(R.string.falkland_islands), "500")
        val subData1dollar5cents9 =
            TableSubModel(getString(R.string.ivory_coast_special_services), "225")
        val subData1dollar5cents10 = TableSubModel(getString(R.string.kiribati), "686")
        val subData1dollar5cents11 = TableSubModel(getString(R.string.madagascar), "261")
        val subData1dollar5cents12 = TableSubModel(getString(R.string.maldives), "960")
        val subData1dollar5cents13 = TableSubModel(getString(R.string.nauru), "674")
        val subData1dollar5cents14 = TableSubModel(getString(R.string.niue_island), "683")
        val subData1dollar5cents15 = TableSubModel(getString(R.string.solomon_islands), "677")
        val subData1dollar5cents16 = TableSubModel(getString(R.string.st_helena), "290")
        val subData1dollar5cents17 = TableSubModel(getString(R.string.tokelau), "690")
        val subData1dollar5cents18 = TableSubModel(getString(R.string.tuvalu), "688")

        tableDataSubList1dollar5cents.add(subData1dollar5cents1)
        tableDataSubList1dollar5cents.add(subData1dollar5cents2)
        tableDataSubList1dollar5cents.add(subData1dollar5cents3)
        tableDataSubList1dollar5cents.add(subData1dollar5cents4)
        tableDataSubList1dollar5cents.add(subData1dollar5cents5)
        tableDataSubList1dollar5cents.add(subData1dollar5cents6)
        tableDataSubList1dollar5cents.add(subData1dollar5cents7)
        tableDataSubList1dollar5cents.add(subData1dollar5cents8)
        tableDataSubList1dollar5cents.add(subData1dollar5cents9)
        tableDataSubList1dollar5cents.add(subData1dollar5cents10)
        tableDataSubList1dollar5cents.add(subData1dollar5cents11)
        tableDataSubList1dollar5cents.add(subData1dollar5cents12)
        tableDataSubList1dollar5cents.add(subData1dollar5cents13)
        tableDataSubList1dollar5cents.add(subData1dollar5cents14)
        tableDataSubList1dollar5cents.add(subData1dollar5cents15)
        tableDataSubList1dollar5cents.add(subData1dollar5cents16)
        tableDataSubList1dollar5cents.add(subData1dollar5cents17)
        tableDataSubList1dollar5cents.add(subData1dollar5cents18)


        val tableMode1dollar5cent =
            TableModel("1.5 $str1Dollar5Cent", tableDataSubList1dollar5cents)

        //Data 2$
        val tableDataSubList2dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        val strCent2Dollar = text_cents_min.text
        val subData2dollar = TableSubModel(getString(R.string.sao_tome_principe), "239")
        tableDataSubList2dollar.add(subData2dollar)
        val tableMode2dollar = TableModel("2 $strCent2Dollar", tableDataSubList2dollar)
        //Data 3$
        val tableDataSubList3dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        val strCent3Dollar = text_cents_min.text
        val subData3dollar =
            TableSubModel(getString(R.string.de_rep_of_congo_special_services), "243")
        val subData3dollar1 = TableSubModel(getString(R.string.inmarsat_unified), "870")
        tableDataSubList3dollar.add(subData3dollar)
        tableDataSubList3dollar.add(subData3dollar1)
        val tableMode3dollar = TableModel("3 $strCent3Dollar", tableDataSubList3dollar)
        val tableDataSubList4dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        val strCent4Dollar = text_cents_min.text
        val subData4dollar = TableSubModel(getString(R.string.russia_satellite_globaltel), "7")
        tableDataSubList4dollar.add(subData4dollar)
        val tableMode4dollar = TableModel("4 $strCent4Dollar", tableDataSubList4dollar)

        val tableDataSubList5dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        val strCent5Dollar = text_cents_min.text
        val subData5dollar = TableSubModel(getString(R.string.australia_territories), "672")
        val subData5dollar1 = TableSubModel(getString(R.string.diego_garcia), "246")
        tableDataSubList5dollar.add(subData5dollar)
        tableDataSubList5dollar.add(subData5dollar1)
        val tableMode5dollar = TableModel("5 $strCent5Dollar", tableDataSubList5dollar)

        val tableDataSubList6dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        val strCent6Dollar = text_cents_min.text
        val subData6dollar = TableSubModel(getString(R.string.global_network), "881")
        val subData6dollar1 = TableSubModel(getString(R.string.inmarsat_global), "870")
        val subData6dollar2 = TableSubModel(getString(R.string.international_networks_2), "883")
        tableDataSubList6dollar.add(subData6dollar)
        tableDataSubList6dollar.add(subData6dollar1)
        tableDataSubList6dollar.add(subData6dollar2)
        val tableMode6dollar = TableModel("6 $strCent6Dollar", tableDataSubList6dollar)

        val tableDataSubList8dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        val strCent8Dollar = text_cents_min.text
        val subData8dollar = TableSubModel(getString(R.string.inmarsat_unified), "870")
        val subData8dollar1 = TableSubModel(getString(R.string.international_networks), "882")
        tableDataSubList8dollar.add(subData8dollar)
        tableDataSubList8dollar.add(subData8dollar1)
        val tableMode8dollar = TableModel("8 $strCent8Dollar", tableDataSubList8dollar)


        val tableDataSubList10dollar = ArrayList<TableSubModel>()
        text_cents_min.text = getString(R.string.dollar)
        val str10Dollar = text_cents_min.text
        val subData10dollar = TableSubModel(getString(R.string.inmarsat_HSD), "870")
        tableDataSubList10dollar.add(subData10dollar)
        val tableMode10dollar = TableModel("10 $str10Dollar", tableDataSubList10dollar)

        tableDataList.clear()
        tableDataList.add(tableModel)
        tableDataList.add(tableModel1)
        tableDataList.add(tableModel2)
        tableDataList.add(tableModel5)
        tableDataList.add(tableMode25)
        tableDataList.add(tableMode30)
        tableDataList.add(tableMode50)
        tableDataList.add(tableMode1dollar)
        tableDataList.add(tableMode1dollar5cent)
        tableDataList.add(tableMode2dollar)
        tableDataList.add(tableMode3dollar)
        tableDataList.add(tableMode4dollar)
        tableDataList.add(tableMode5dollar)
        tableDataList.add(tableMode6dollar)
        tableDataList.add(tableMode8dollar)
        tableDataList.add(tableMode10dollar)
        tableDataListDisplay.addAll(tableDataList)
        mAdapter.notifyDataSetChanged()
        Handler().postDelayed({
            tableDataListDisplay.clear()
        }, 200)

        error_view.visibility = View.GONE
//        return tableDataList
        val tableCountry = ArrayList<CountryModel>()
        val subdata = CountryModel(
            SeatelUtils.translatForDialog(requireContext(), getString(R.string.all)), ""
        )
        val country20 = CountryModel(getString(R.string.inmarsat_HSD), "870")
        val country1 = CountryModel(getString(R.string.china), "86")
        val country2 = CountryModel(getString(R.string.hong_kong_china), "852")
        val country3 = CountryModel(getString(R.string.malaysia), "60")
        val country4 = CountryModel(getString(R.string.singapore), "65")
        val country5 = CountryModel(getString(R.string.thailand), "66")
        val country6 = CountryModel(getString(R.string.american_samoa), "1")
        val country7 = CountryModel(getString(R.string.bangladesh), "880")
        val country8 = CountryModel(getString(R.string.canada), "1")
        val country9 = CountryModel(getString(R.string.denmark), "45")
        val country10 = CountryModel(getString(R.string.guam), "1")
        val country11 = CountryModel(getString(R.string.hungary), "36")
        val country12 = CountryModel(getString(R.string.iceland), "354")
        val country13 = CountryModel(getString(R.string.india), "91")
        val country14 = CountryModel(getString(R.string.malta_Mobile), "356")
        val country15 = CountryModel(getString(R.string.mariana_islands), "1")
        val country16 = CountryModel(getString(R.string.puerto_rico), "1")
        val country17 = CountryModel(getString(R.string.romania), "40")
        val country18 = CountryModel(getString(R.string.south_korea), "82")
        val country19 = CountryModel(getString(R.string.sweden), "46")
        val country21 = CountryModel(getString(R.string.australia), "61")
        val country22 = CountryModel(getString(R.string.australia_mobile_Satellite), "61")
        val country23 = CountryModel(getString(R.string.bermuda), "1")
        val country24 = CountryModel(getString(R.string.brunei), "673")
//        val subData10cent5 = TableSubModel(getString(R.string.cambodia), "855")
        val country25 = CountryModel(getString(R.string.canada_Yukon_NW_Territories), "1")
        val country26 = CountryModel(getString(R.string.costa_rica), "506")
        val country27 = CountryModel(getString(R.string.czech_republic), "420")
        val country28 =
            CountryModel(getString(R.string.france_mobile_globalstar_special_services), "33")
        val country29 = CountryModel(getString(R.string.french_guiana), "594")
        val country30 = CountryModel(getString(R.string.greece), "30")
        val country31 = CountryModel(getString(R.string.guadeloupe), "590")
        val country32 = CountryModel(getString(R.string.indonesia), "62")
        val country33 = CountryModel(getString(R.string.japan), "81")
        val country34 = CountryModel(getString(R.string.kazakhstan_other_OLO), "7")
        val country35 = CountryModel(getString(R.string.macau), "853")
        val country36 = CountryModel(getString(R.string.martinique), "596")
        val country37 = CountryModel(getString(R.string.mayotte), "262")
        val country38 = CountryModel(getString(R.string.mexico), "52")
        val country39 = CountryModel(getString(R.string.mongolia), "976")
        val country40 = CountryModel(getString(R.string.namibia), "264")
        val country41 = CountryModel(getString(R.string.new_zealand), "64")
        val country42 = CountryModel(getString(R.string.nigeria_mobile), "234")
        val country43 = CountryModel(getString(R.string.pakistan), "92")
        val country44 = CountryModel(getString(R.string.reunion_island_mobile), "262")
        val country45 = CountryModel(getString(R.string.russia_moscow_central), "7")
        val country46 = CountryModel(getString(R.string.russia_other), "7")
        val country47 = CountryModel(getString(R.string.russia_st_petersburg), "7")
        val country48 = CountryModel(getString(R.string.universal_disaster_relief), "888")
        val country49 = CountryModel(getString(R.string.usa_lata), "1")
        val country50 = CountryModel(getString(R.string.usa_other_mainland), "1")
        val country51 = CountryModel(getString(R.string.uzbekistan), "998")
        val country53 = CountryModel(getString(R.string.vietnam), "84")
        val country54 = CountryModel(getString(R.string.angola), "224")
        val country55 = CountryModel(getString(R.string.argentina), "54")
        val country56 = CountryModel(getString(R.string.bahrain), "973")
        val country57 = CountryModel(getString(R.string.bhutan), "975")
        val country58 = CountryModel(getString(R.string.cyprus), "357")
        val country59 = CountryModel(getString(R.string.dominican_republic), "1")
        val country60 = CountryModel(getString(R.string.egypt), "20")
        val country61 = CountryModel(getString(R.string.ireland), "353")
        val country62 = CountryModel(getString(R.string.kuwait_mobile), "965")
        val country63 = CountryModel(getString(R.string.laos), "856")
        val country64 = CountryModel(getString(R.string.liechtenstein_special_services), "423")
        val country65 = CountryModel(getString(R.string.luxembourg), "352")
        val country66 = CountryModel(getString(R.string.nepal), "977")
        val country67 = CountryModel(getString(R.string.paraguay), "595")
        val country68 = CountryModel(getString(R.string.reunion_island_mobile), "262")
        val country69 = CountryModel(getString(R.string.saudi_arabia), "966")
        val country70 = CountryModel(getString(R.string.slovakia), "421")
        val country71 = CountryModel(getString(R.string.st_maarten), "1721")
        val country72 = CountryModel(getString(R.string.taiwan), "886")
        val country73 = CountryModel(getString(R.string.venezuela), "58")
        val country74 = CountryModel(getString(R.string.iran), "98")
        val country75 = CountryModel(getString(R.string.jordan), "962")
        val country76 = CountryModel(getString(R.string.norway), "47")
        val country77 = CountryModel(getString(R.string.south_africa), "27")
        val country78 = CountryModel(getString(R.string.abkhazia), "7")
        val country79 = CountryModel(getString(R.string.afghanistan), "93")
        val country80 = CountryModel(getString(R.string.andorra), "376")
        val country81 = CountryModel(getString(R.string.aruba), "297")
        val country82 = CountryModel(getString(R.string.bahamas), "1")
        val country83 = CountryModel(getString(R.string.bolivia), "591")
        val country84 = CountryModel(getString(R.string.cayman_islands), "1")
        val country85 = CountryModel(getString(R.string.colombia), "57")
        val country86 = CountryModel(getString(R.string.ecuador), "593")
        val country87 = CountryModel(getString(R.string.el_salvador), "503")
        val country88 = CountryModel(getString(R.string.faroe_islands), "298")
        val country89 = CountryModel(getString(R.string.ghana), "233")
        val country90 = CountryModel(getString(R.string.gibraltar), "350")
        val country91 = CountryModel(getString(R.string.guatemala), "502")
        val country92 = CountryModel(getString(R.string.honduras), "504")
        val country93 = CountryModel(getString(R.string.iraq), "964")
        val country94 = CountryModel(getString(R.string.israel), "972")
        val country95 = CountryModel(getString(R.string.kyrgyzstan), "996")
        val country96 = CountryModel(getString(R.string.lebanon), "961")
        val country97 = CountryModel(getString(R.string.marshall_islands), "692")
        val country98 = CountryModel(getString(R.string.netherlands_antilles), "599")
        val country99 = CountryModel(getString(R.string.new_caledonia), "687")
        val country100 = CountryModel(getString(R.string.palestine), "970")
        val country101 = CountryModel(getString(R.string.panama), "507")
        val country102 = CountryModel(getString(R.string.philippines), "63")
        val country103 = CountryModel(getString(R.string.qatar), "974")
        val country104 = CountryModel(getString(R.string.rusia_other1), "7")
        val country105 = CountryModel(getString(R.string.spain), "34")
        val country106 = CountryModel(getString(R.string.sri_lanka), "94")
        val country107 = CountryModel(getString(R.string.sudan), "249")
        val country108 = CountryModel(getString(R.string.swaziland), "268")
        val country109 = CountryModel(getString(R.string.syria), "963")
        val country110 = CountryModel(getString(R.string.tadjikistan), "992")
        val country111 = CountryModel(getString(R.string.trinidad_tobago), "1")
        val country112 = CountryModel(getString(R.string.turkey), "90")
        val country113 = CountryModel(getString(R.string.turkmenistan), "993")
        val country114 = CountryModel(getString(R.string.universal_disaster_relief), "888")
        val country115 = CountryModel(getString(R.string.uruguay_mobile), "598")
        val country116 = CountryModel(getString(R.string.yemen), "967")
        val country117 = CountryModel(getString(R.string.zambia_mobile), "260")
        val country118 = CountryModel(getString(R.string.antigua_barbuda), "1")
        val country119 = CountryModel(getString(R.string.armenia), "374")
        val country120 = CountryModel(getString(R.string.austria), "43")
        val country121 = CountryModel(getString(R.string.austria), "43")
        val country122 = CountryModel(getString(R.string.belize), "501")
        val country123 = CountryModel(getString(R.string.botswana), "267")
        val country124 = CountryModel(getString(R.string.brazil), "55")
        val country125 = CountryModel(getString(R.string.british_virgin_islands), "1")
        val country126 = CountryModel(getString(R.string.dominica), "1")
        val country127 = CountryModel(getString(R.string.eritrea), "291")
        val country128 = CountryModel(getString(R.string.ethiopia), "251")
        val country129 = CountryModel(getString(R.string.georgia), "995")
        val country130 = CountryModel(getString(R.string.germany), "49")
        val country131 = CountryModel(getString(R.string.guyana), "592")
        val country132 = CountryModel(getString(R.string.italy), "39")
        val country133 = CountryModel(getString(R.string.jamaica), "1")
        val country134 = CountryModel(getString(R.string.kenya), "254")
        val country135 = CountryModel(getString(R.string.libya), "254")
        val country136 = CountryModel(getString(R.string.montserrat), "1")
        val country137 = CountryModel(getString(R.string.myanmar), "95")
        val country138 = CountryModel(getString(R.string.netherlands), "31")
        val country139 = CountryModel(getString(R.string.nicaragua), "505")
        val country140 = CountryModel(getString(R.string.oman), "968")
        val country141 = CountryModel(getString(R.string.san_marino), "378")
        val country142 = CountryModel(getString(R.string.st_kitts_nevis), "1")
        val country143 = CountryModel(getString(R.string.st_lucia), "1")
        val country144 = CountryModel(getString(R.string.st_pierre_miquelon), "508")
        val country145 = CountryModel(getString(R.string.st_vincent_grenadines), "1")
        val country146 = CountryModel(getString(R.string.turks_caicos_islands), "1")
        val country147 = CountryModel(getString(R.string.ukraine), "380")
        val country148 = CountryModel(getString(R.string.united_arab_emirates), "44")
        val country149 = CountryModel(getString(R.string.wallis_futuna), "681")
        val country150 = CountryModel(getString(R.string.albania), "355")
        val country151 = CountryModel(getString(R.string.algeria), "213")
        val country152 = CountryModel(getString(R.string.anguilla), "1")
        val country153 = CountryModel(getString(R.string.austria_toll_shared), "43")
        val country154 = CountryModel(getString(R.string.azerbaijan), "994")
        val country155 = CountryModel(getString(R.string.belarus), "375")
        val country156 = CountryModel(getString(R.string.belgium), "32")
        val country157 = CountryModel(getString(R.string.benin), "229")
        val country158 = CountryModel(getString(R.string.bosnia_herzegovina), "387")
        val country159 = CountryModel(getString(R.string.bulgaria), "359")
        val country160 = CountryModel(getString(R.string.burkina_faso), "226")
        val country161 = CountryModel(getString(R.string.burundi), "257")
        val country162 = CountryModel(getString(R.string.cape_verde), "238")
        val country163 = CountryModel(getString(R.string.comoros), "269")
        val country164 = CountryModel(getString(R.string.congo), "242")
        val country165 = CountryModel(getString(R.string.croatia), "385")
        val country166 = CountryModel(getString(R.string.dem_rep), "243")
        val country167 = CountryModel(getString(R.string.djibouti), "253")
        val country168 = CountryModel(getString(R.string.equatorial_guinea), "240")
        val country169 = CountryModel(getString(R.string.estonia_special_services), "372")
        val country170 = CountryModel(getString(R.string.fiji), "679")
        val country171 = CountryModel(getString(R.string.finland), "358")
        val country172 = CountryModel(getString(R.string.france), "33")
        val country173 = CountryModel(getString(R.string.french_polynesia), "689")
        val country174 = CountryModel(getString(R.string.grenada), "1")
        val country175 = CountryModel(getString(R.string.guinea), "224")
        val country176 = CountryModel(getString(R.string.guinea_bissau), "245")
        val country177 = CountryModel(getString(R.string.haiti), "509")
        val country178 = CountryModel(getString(R.string.pivory_coast), "225")
        val country179 = CountryModel(getString(R.string.lesotho), "266")
        val country180 = CountryModel(getString(R.string.liberia), "231")
        val country181 = CountryModel(getString(R.string.macedonia), "389")
        val country182 = CountryModel(getString(R.string.malawi), "265")
        val country183 = CountryModel(getString(R.string.mali), "223")
        val country184 = CountryModel(getString(R.string.micronesia), "691")
        val country185 = CountryModel(getString(R.string.moldova), "373")
        val country186 = CountryModel(getString(R.string.monaco), "377")
        val country187 = CountryModel(getString(R.string.montenegro), "382")
        val country188 = CountryModel(getString(R.string.morocco), "212")
        val country189 = CountryModel(getString(R.string.mozambique), "258")
        val country190 = CountryModel(getString(R.string.niger), "227")
        val country191 = CountryModel(getString(R.string.niger_special_services), "227")
        val country192 = CountryModel(getString(R.string.peru), "51")
        val country193 = CountryModel(getString(R.string.portugal), "351")
        val country194 = CountryModel(getString(R.string.rwanda), "351")
        val country195 = CountryModel(getString(R.string.senegal), "221")
        val country196 = CountryModel(getString(R.string.serbia), "221")
        val country197 = CountryModel(getString(R.string.slovenia), "386")
        val country198 = CountryModel(getString(R.string.south_sfrica_special_services), "27")
        val country199 = CountryModel(getString(R.string.south_sudan), "221")
        val country200 = CountryModel(getString(R.string.swaziland), "41")
        val country201 = CountryModel(getString(R.string.tanzania), "255")
        val country202 = CountryModel(getString(R.string.togo), "228")
        val country203 = CountryModel(getString(R.string.uganda), "256")
        val country204 = CountryModel(getString(R.string.zimbabwe), "263")
        val country205 = CountryModel(getString(R.string.antarctica), "6721")
        val country206 = CountryModel(getString(R.string.ascension_island), "247")
        val country207 = CountryModel(getString(R.string.australia_territories), "6723")
        val country208 = CountryModel(getString(R.string.barbados), "1")
        val country209 = CountryModel(getString(R.string.belarus_special_services), "375")
        val country210 = CountryModel(getString(R.string.cameroon_special_services), "237")
        val country211 = CountryModel(getString(R.string.comoros_special_services), "269")
        val country212 = CountryModel(getString(R.string.falkland_islands), "500")
        val country213 = CountryModel(getString(R.string.ivory_coast_special_services), "225")
        val country214 = CountryModel(getString(R.string.kiribati), "686")
        val country215 = CountryModel(getString(R.string.madagascar), "261")
        val country216 = CountryModel(getString(R.string.maldives), "960")
        val country217 = CountryModel(getString(R.string.nauru), "674")
        val country218 = CountryModel(getString(R.string.niue_island), "683")
        val country219 = CountryModel(getString(R.string.solomon_islands), "677")
        val country220 = CountryModel(getString(R.string.st_helena), "290")
        val country221 = CountryModel(getString(R.string.tokelau), "690")
        val country222 = CountryModel(getString(R.string.tuvalu), "688")
        val country223 = CountryModel(getString(R.string.sao_tome_principe), "239")
        val country224 = CountryModel(getString(R.string.de_rep_of_congo_special_services), "243")
        val country225 = CountryModel(getString(R.string.inmarsat_unified), "870")
        val country226 = CountryModel(getString(R.string.russia_satellite_globaltel), "7")
        val country227 = CountryModel(getString(R.string.australia_territories), "672")
        val country228 = CountryModel(getString(R.string.diego_garcia), "246")
        val country229 = CountryModel(getString(R.string.global_network), "881")
        val country230 = CountryModel(getString(R.string.inmarsat_global), "870")
        val country231 = CountryModel(getString(R.string.international_networks_2), "883")
        val country232 = CountryModel(getString(R.string.inmarsat_unified), "870")
        val country233 = CountryModel(getString(R.string.international_networks), "882")
        val country234 = CountryModel(getString(R.string.inmarsat_HSD), "870")






        tableCountry.add(subdata)
        tableCountry.add(country1)
        tableCountry.add(country2)
        tableCountry.add(country3)
        tableCountry.add(country4)
        tableCountry.add(country5)
        tableCountry.add(country6)
        tableCountry.add(country7)
        tableCountry.add(country8)
        tableCountry.add(country9)
        tableCountry.add(country10)
        tableCountry.add(country11)
        tableCountry.add(country12)
        tableCountry.add(country13)
        tableCountry.add(country14)
        tableCountry.add(country15)
        tableCountry.add(country16)
        tableCountry.add(country17)
        tableCountry.add(country18)
        tableCountry.add(country19)
        tableCountry.add(country20)
        tableCountry.add(country21)
        tableCountry.add(country22)
        tableCountry.add(country23)
        tableCountry.add(country24)
        tableCountry.add(country25)
        tableCountry.add(country26)
        tableCountry.add(country27)
        tableCountry.add(country28)
        tableCountry.add(country29)
        tableCountry.add(country30)
        tableCountry.add(country31)
        tableCountry.add(country32)
        tableCountry.add(country33)
        tableCountry.add(country34)
        tableCountry.add(country35)
        tableCountry.add(country36)
        tableCountry.add(country37)
        tableCountry.add(country38)
        tableCountry.add(country39)
        tableCountry.add(country40)
        tableCountry.add(country41)
        tableCountry.add(country42)
        tableCountry.add(country43)
        tableCountry.add(country44)
        tableCountry.add(country45)
        tableCountry.add(country46)
        tableCountry.add(country47)
        tableCountry.add(country48)
        tableCountry.add(country49)
        tableCountry.add(country50)
        tableCountry.add(country51)
        tableCountry.add(country53)
        tableCountry.add(country54)
        tableCountry.add(country55)
        tableCountry.add(country56)
        tableCountry.add(country57)
        tableCountry.add(country58)
        tableCountry.add(country59)
        tableCountry.add(country60)
        tableCountry.add(country61)
        tableCountry.add(country62)
        tableCountry.add(country63)
        tableCountry.add(country64)
        tableCountry.add(country65)
        tableCountry.add(country66)
        tableCountry.add(country67)
        tableCountry.add(country68)
        tableCountry.add(country69)
        tableCountry.add(country70)
        tableCountry.add(country71)
        tableCountry.add(country72)
        tableCountry.add(country73)
        tableCountry.add(country74)
        tableCountry.add(country75)
        tableCountry.add(country76)
        tableCountry.add(country77)
        tableCountry.add(country78)
        tableCountry.add(country79)
        tableCountry.add(country80)
        tableCountry.add(country81)
        tableCountry.add(country82)
        tableCountry.add(country83)
        tableCountry.add(country84)
        tableCountry.add(country85)
        tableCountry.add(country86)
        tableCountry.add(country87)
        tableCountry.add(country88)
        tableCountry.add(country89)
        tableCountry.add(country90)
        tableCountry.add(country91)
        tableCountry.add(country92)
        tableCountry.add(country93)
        tableCountry.add(country94)
        tableCountry.add(country95)
        tableCountry.add(country96)
        tableCountry.add(country97)
        tableCountry.add(country98)
        tableCountry.add(country99)
        tableCountry.add(country99)
        tableCountry.add(country100)
        tableCountry.add(country101)
        tableCountry.add(country102)
        tableCountry.add(country103)
        tableCountry.add(country104)
        tableCountry.add(country105)
        tableCountry.add(country106)
        tableCountry.add(country107)
        tableCountry.add(country108)
        tableCountry.add(country109)
        tableCountry.add(country110)
        tableCountry.add(country111)
        tableCountry.add(country112)
        tableCountry.add(country113)
        tableCountry.add(country114)
        tableCountry.add(country115)
        tableCountry.add(country116)
        tableCountry.add(country117)
        tableCountry.add(country118)
        tableCountry.add(country119)
        tableCountry.add(country120)
        tableCountry.add(country121)
        tableCountry.add(country122)
        tableCountry.add(country123)
        tableCountry.add(country124)
        tableCountry.add(country125)
        tableCountry.add(country126)
        tableCountry.add(country127)
        tableCountry.add(country128)
        tableCountry.add(country129)
        tableCountry.add(country130)
        tableCountry.add(country131)
        tableCountry.add(country132)
        tableCountry.add(country133)
        tableCountry.add(country134)
        tableCountry.add(country135)
        tableCountry.add(country136)
        tableCountry.add(country136)
        tableCountry.add(country137)
        tableCountry.add(country138)
        tableCountry.add(country139)
        tableCountry.add(country140)
        tableCountry.add(country141)
        tableCountry.add(country142)
        tableCountry.add(country143)
        tableCountry.add(country144)
        tableCountry.add(country145)
        tableCountry.add(country146)
        tableCountry.add(country147)
        tableCountry.add(country148)
        tableCountry.add(country149)
        tableCountry.add(country150)
        tableCountry.add(country151)
        tableCountry.add(country152)
        tableCountry.add(country153)
        tableCountry.add(country154)
        tableCountry.add(country155)
        tableCountry.add(country156)
        tableCountry.add(country157)
        tableCountry.add(country158)
        tableCountry.add(country159)
        tableCountry.add(country160)
        tableCountry.add(country161)
        tableCountry.add(country162)
        tableCountry.add(country163)
        tableCountry.add(country164)
        tableCountry.add(country165)
        tableCountry.add(country166)
        tableCountry.add(country167)
        tableCountry.add(country168)
        tableCountry.add(country169)
        tableCountry.add(country170)
        tableCountry.add(country171)
        tableCountry.add(country172)
        tableCountry.add(country173)
        tableCountry.add(country173)
        tableCountry.add(country174)
        tableCountry.add(country175)
        tableCountry.add(country176)
        tableCountry.add(country177)
        tableCountry.add(country178)
        tableCountry.add(country179)
        tableCountry.add(country180)
        tableCountry.add(country181)
        tableCountry.add(country182)
        tableCountry.add(country183)
        tableCountry.add(country184)
        tableCountry.add(country185)
        tableCountry.add(country186)
        tableCountry.add(country187)
        tableCountry.add(country188)
        tableCountry.add(country189)
        tableCountry.add(country190)
        tableCountry.add(country191)
        tableCountry.add(country192)
        tableCountry.add(country193)
        tableCountry.add(country194)
        tableCountry.add(country195)
        tableCountry.add(country196)
        tableCountry.add(country197)
        tableCountry.add(country198)
        tableCountry.add(country199)
        tableCountry.add(country200)
        tableCountry.add(country201)
        tableCountry.add(country202)
        tableCountry.add(country203)
        tableCountry.add(country204)
        tableCountry.add(country205)
        tableCountry.add(country206)
        tableCountry.add(country207)
        tableCountry.add(country208)
        tableCountry.add(country209)
        tableCountry.add(country210)
        tableCountry.add(country211)
        tableCountry.add(country212)
        tableCountry.add(country213)
        tableCountry.add(country214)
        tableCountry.add(country215)
        tableCountry.add(country216)
        tableCountry.add(country217)
        tableCountry.add(country218)
        tableCountry.add(country219)
        tableCountry.add(country220)
        tableCountry.add(country221)
        tableCountry.add(country222)
        tableCountry.add(country223)
        tableCountry.add(country224)
        tableCountry.add(country225)
        tableCountry.add(country226)
//        tableCountry.add(country227)
        tableCountry.add(country228)
        tableCountry.add(country229)
        tableCountry.add(country230)
        tableCountry.add(country231)
        tableCountry.add(country232)
        tableCountry.add(country233)
        tableCountry.add(country234)


        //Adapter Spinner
        val adapter = ArrayAdapter<CountryModel>(
            requireContext(), android.R.layout.simple_spinner_item, tableCountry
        )

        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        //  val sItems = findViewById<Spinner>(R.id.filter)
        // sItems.setBackgroundColor(Color.TRANSPARENT)
        filter.adapter = adapter
        filter.setSelection(0)
        filter.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onItemSelected(
                parent: AdapterView<*>, view: View, position: Int, id: Long
            ) {
                val selectedItemText = parent.getItemAtPosition(position)
                //Sort data when Click on Spinner
                tableCountry.sortWith(Comparator { item, t1 ->
                    val s1 = item.destination
                    val s2 = t1.destination
                    s1.compareTo(s2, ignoreCase = true)

                })
                addAllToList(tableCountry)
                if (parent.getItemAtPosition(position).equals(
                        SeatelUtils.translatForDialog(
                            requireContext(), getString(R.string.all)
                        )
                    )
                ) {

                } else {
                    //tableCountry[0].destination = getString(R.string.all)
                    tableDataListDisplay.addAll(tableDataList)
                    adapter.notifyDataSetChanged()
                    mAdapter.notifyDataSetChanged()


                }
                val itemCountry = adapter.getItem(position)
//              mAdapter.filter.filter(itemCountry.destination)
                filter(itemCountry!!.destination)

            }

            override fun onNothingSelected(parent: AdapterView<*>) {
            }


        }

    }

    fun filter(charString: String) {
        val tableModel = TableModel(charString, ArrayList())
        val index = tableDataList.indexOf(tableModel)
        if (index != -1) {
            val tmptableModel = tableDataList[index]
            val tableSubModel = TableSubModel(charString, "")

            val indexSub: Int = tmptableModel.destination!!.indexOf(tableSubModel)
            if (indexSub != -1) {
                val tmpSubTable = tmptableModel.destination!![indexSub]
                val subList = ArrayList<TableSubModel>()
                subList.add(tmpSubTable)
                val newTableModel = TableModel(tmptableModel.standard, subList)

                tableDataListDisplay.clear()
                tableDataListDisplay.add(newTableModel)
                mAdapter.notifyDataSetChanged()
                Handler().postDelayed({
                    tableDataListDisplay.clear()
                }, 200)

            }
        }


    }

    private fun addAllToList(tableCountry: ArrayList<CountryModel>) {
        var indexChange = 0
        for (i in tableCountry.indices) {
            if (TextUtils.equals(
                    tableCountry[i].destination,
                    SeatelUtils.translatForDialog(requireContext(), getString(R.string.all))
                )
            ) {
                indexChange = i
                break
            }
        }
        if (indexChange > 0) {
            val temp = tableCountry[indexChange]
            val temp2 = tableCountry[0]
            tableCountry[0] = temp
            tableCountry[indexChange] = temp2
        }
    }

    override fun onGetAppProductsSucceed(appProductsList: ArrayList<AppProductsResponseModel>) {
        if (!appProductsList.isNullOrEmpty()) {


            val mPlanList: ArrayList<AppProductsResponseModel> = ArrayList()
            for (i in 0 until appProductsList.size) {

                if (appProductsList[i].type == "plan") {
                    mPlanList.add(appProductsList[i])
                    switchPlanName = mPlanList[0].name
                    canChangePlan = mPlanList[0].canChangePlan!!
                    if (activity != null) {
                        if (mPlanList[0].code.equals("rik-reay")) {
                            RikReayPresenter(requireContext(), this).RikReay()
                        } else ProductServiceDetailPrsenter(
                            requireActivity(), this
                        ).onProServiceDetail(mPlanList[0].code!!, getPhoneLogin())
                    }


                    canSubscribe = appProductsList[0].canSubscribe!!
                    if (activity != null) {
                        mRecyclerCategory.adapter =
                            ProductServicePackageAdapter(requireContext(), mPlanList) {
                                error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                                AnalyticsHelper.logEvent(
                                    AnalyticsHelper.Event.PACKAGE_TAP + "${it.code}", null
                                )
                                canSubscribe = it.canSubscribe!!
                                canChangePlan = it.canChangePlan!!
                                newPlanCode = it.subscriptionPlan
                                switchPlanName = it.name

                                if (it.code.equals("rik-reay")) {
                                    RikReayPresenter(requireContext(), this).RikReay()
                                } else ProductServiceDetailPrsenter(
                                    requireActivity(), this
                                ).onProServiceDetail(it.code!!, getPhoneLogin())

                            }
                    }
                }


            }

            btn_plan.setOnClickListener {
                btn_plan.setBackgroundColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.colorPrimary
                    )
                )
                btn_package.setBackgroundColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.colorPinkSoft
                    )
                )

                val mPlanList: ArrayList<AppProductsResponseModel> = ArrayList()
                for (i in 0 until appProductsList.size) {

                    if (appProductsList[i].type == "plan") {
                        mPlanList.add(appProductsList[i])
                        canChangePlan = mPlanList[0].canChangePlan!!
                        if (activity != null) {
                            if (mPlanList[0].code.equals("rik-reay")) {
                                RikReayPresenter(requireContext(), this).RikReay()
                            } else ProductServiceDetailPrsenter(
                                requireActivity(), this
                            ).onProServiceDetail(mPlanList[0].code!!, getPhoneLogin())
                        }
                        if (mPlanList[0].code.equals("rik-reay")) {
                            RikReayPresenter(requireContext(), this).RikReay()
                        } else ProductServiceDetailPrsenter(
                            requireActivity(), this
                        ).onProServiceDetail(mPlanList[0].code!!, getPhoneLogin())
                        canSubscribe = appProductsList[0].canSubscribe!!
                        if (activity != null) {
                            mRecyclerCategory.adapter =
                                ProductServicePackageAdapter(requireContext(), mPlanList) {
                                    error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                                    AnalyticsHelper.logEvent(
                                        AnalyticsHelper.Event.PACKAGE_TAP + "${it.code}", null
                                    )
                                    canSubscribe = it.canSubscribe!!
                                    canChangePlan = it.canChangePlan!!
                                    newPlanCode = it.subscriptionPlan
                                    switchPlanName = it.name

                                    if (it.code.equals("rik-reay")) {
                                        RikReayPresenter(requireContext(), this).RikReay()
                                    } else ProductServiceDetailPrsenter(
                                        requireActivity(), this
                                    ).onProServiceDetail(it.code!!, getPhoneLogin())

                                }
                        }
                    }


                }
            }

            btn_package.setOnClickListener {
                btn_package.setBackgroundColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.colorPrimary
                    )
                )
                btn_plan.setBackgroundColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.colorPinkSoft
                    )
                )

                val mPlanList: ArrayList<AppProductsResponseModel> = ArrayList()
                for (i in 0 until appProductsList.size) {

                    if (appProductsList[i].type == "add-on") {
                        mPlanList.add(appProductsList[i])
                        canChangePlan = mPlanList[0].canChangePlan!!
                        if (mPlanList[0].code.equals("rik-reay")) {
                            RikReayPresenter(requireContext(), this).RikReay()
                        } else ProductServiceDetailPrsenter(
                            requireActivity(), this
                        ).onProServiceDetail(mPlanList[0].code!!, getPhoneLogin())
                    }
                    canSubscribe = appProductsList[0].canSubscribe!!
                    if (activity != null) {
                        mRecyclerCategory.adapter =
                            ProductServicePackageAdapter(requireContext(), mPlanList) {
                                error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                                AnalyticsHelper.logEvent(
                                    AnalyticsHelper.Event.PACKAGE_TAP + "${it.code}", null
                                )
                                canSubscribe = it.canSubscribe!!
                                canChangePlan = it.canChangePlan!!
                                newPlanCode = it.subscriptionPlan
                                switchPlanName = it.name

                                if (it.code.equals("rik-reay")) {
                                    RikReayPresenter(requireContext(), this).RikReay()
                                } else ProductServiceDetailPrsenter(
                                    requireActivity(), this
                                ).onProServiceDetail(it.code!!, getPhoneLogin())

                            }
                    }
                }


            }
        }


    }


    override fun onGetAppProductsFailed(error: VolleyError) {
        when (error) {
            is TimeoutError -> {


                error_view.errorMessage = getString(R.string.connection_timeout)
                error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                error_view.errorMessage = getString(R.string.message_no_internet)
                error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                error_view.errorMessage = getString(R.string.no_data)
                error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    override fun onProServiceDetailSucceed(valuePackSectionModel: ValuePackSectionModel) {
        if (activity != null) {
            Glide.with(requireActivity())
                .load(valuePackSectionModel.dataPackDetailSecOneModel.mobileImageUrl).fitCenter()
                .into(img_international_call_detail)
            Log.d("TAG::>>>", "planType: ${valuePackSectionModel.type}")

            if (canChangePlan) {
                button_switch_plan.visibility = View.VISIBLE
            } else button_switch_plan.visibility = View.GONE

            if (valuePackSectionModel.type.equals("loy-kobs")) {
                btn_data_header.text = "Benefit Offer"
            } else{
                btn_data_header.text = "Data"
                call_sms.visibility = View.GONE
            }

            /*for (i in 0 until valuePackSectionModel.valuePackSecTwoModel.table.size) {
                if (!valuePackSectionModel.valuePackSecTwoModel.table[i].callsmsList.isNullOrEmpty()) {
                    if (valuePackSectionModel.valuePackSecTwoModel.table[i].callsmsList.size > 0) {
                        call_sms.visibility = View.VISIBLE
                    }else
                        call_sms.visibility = View.GONE
                }

            }*/
            if (valuePackSectionModel.valuePackSecTwoModel.addon.size > 0) addon_frame.visibility =
                View.VISIBLE
            else addon_frame.visibility = View.GONE
            valueData = valuePackSectionModel.type
            name = valuePackSectionModel.name

            setupTitle(valuePackSectionModel)
            setupDataList(valuePackSectionModel)
            error_view.visibility = View.GONE
        }

    }

    private fun setupTitle(valuePackSectionModel: ValuePackSectionModel) {
        main_title.text = valuePackSectionModel.valuePackSecTwoModel.title
        sub_title.text = valuePackSectionModel.valuePackSecTwoModel.subTitle
    }

    private fun setupDataList(valuePackSectionModel: ValuePackSectionModel) {
        when {
            valuePackSectionModel.type.equals("one-plan") -> {

                mRecyclerOnePlan.visibility = View.VISIBLE
                layout_product_service_detail.visibility = View.GONE
                view_rik_reay.visibility = View.GONE

                layout_international_call.visibility = View.GONE
                mRecyclerRikReay.visibility = View.GONE

                mRecyclerOnePlan.adapter =
                    OnePlanDetailAdapter(requireContext(), valuePackSectionModel)
            }

            valuePackSectionModel.type.equals("international-call") -> {
                error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                layout_international_call.visibility = View.VISIBLE
                view_rik_reay.visibility = View.GONE
                setupInternationalCall()
            }


            /* valuePackSectionModel.type.equals("rik-reay") -> {

                 mRecyclerRikReay.visibility = View.VISIBLE
                 layout_product_service_detail.visibility = View.GONE
                 mRecyclerOnePlan.visibility = View.GONE

                 layout_international_call.visibility = View.GONE
                 mRecyclerRikReay.adapter =
                     RikReakDetailAdapter(requireContext(), valuePackSectionModel)
             }*/

            else -> {
                if (valuePackSectionModel.valuePackSecThreeModel.description2.isNotEmpty()) {
                    tv_add_on_term_condition.text = "Add-on Terms & Conditions"
                } else tv_add_on_term_condition.text = ""
                layout_international_call.visibility = View.GONE
                view_rik_reay.visibility = View.GONE

                layout_product_service_detail.visibility = View.VISIBLE
                mRecyclerPackage.adapter = ProductServiceDetailAdapter(
                    requireContext(),
                    canSubscribe,
                    valuePackSectionModel.valuePackSecTwoModel.table,
                    this,
                    getPhoneLogin()
                )
                mRecyclerAddOn.apply {

                    adapter = when (valuePackSectionModel.type) {
                        "loy-kobs" -> {

                            base_validity.text = valuePackSectionModel.valuePackSecTwoModel.addon[0].validityDate
                            layoutManager =
                                LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
                            LoyKobAddOnAdapter(
                                context,
                                canSubscribe,
                                valuePackSectionModel.valuePackSecTwoModel.addon,
                                this@PackageFragment,
                                getPhoneLogin()
                            )
                        }

                        else -> {
                            layoutManager =
                                LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
                            AddOnAdapter(
                                context,
                                canSubscribe,
                                valuePackSectionModel.valuePackSecTwoModel.addon,
                                this@PackageFragment,
                                getPhoneLogin()
                            )
                        }
                    }

                }

                mRecyclerTermCondition.adapter = TermAndServiceFooterAdapter(
                    requireContext(),
                    getTermAndServiceEn(valuePackSectionModel.valuePackSecThreeModel.description),
                    true
                )
                mRecyclerAddOnTermCondition.adapter = TermAndServiceFooterAdapter(
                    requireContext(),
                    getTermAndServiceEn(valuePackSectionModel.valuePackSecThreeModel.description2),
                    true
                )
            }
        }


    }

    private fun getTermAndServiceEn(str: String): List<String> {
        val data = ArrayList<String>()
        data.add(str)
        return data
    }


    override fun onProServiceDetailFailed(error: VolleyError) {
        if (activity != null) {
            when (error) {
                is TimeoutError -> {
                    error_view.errorMessage = getString(R.string.connection_timeout)
                    error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
                }

                is NoConnectionError -> {
                    error_view.errorMessage = getString(R.string.message_no_internet)
                    error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
                }

                else -> {
                    error_view.errorMessage = getString(R.string.no_data)
                    error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
                }
            }
        }

    }

    override fun onClick(view: View?) {
        when (view?.id) {
            R.id.btn_benefit -> {
                frame_benefit.visibility = View.VISIBLE
                btn_benefit.setTextColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.colorPrimary
                    )
                )
                btn_benefit.setBackgroundResource(R.drawable.bg_button_cart)
                btn_benefit.isAllCaps = true

                //term condition button
                frame_term_condition.visibility = View.GONE
                btn_term_condition.setTextColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.black
                    )
                )
                btn_term_condition.setBackgroundColor(resources.getColor(R.color.colorItemDataPack))

            }

            R.id.btn_term_condition -> {
                frame_term_condition.visibility = View.VISIBLE
                btn_term_condition.setTextColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.colorPrimary
                    )
                )
                btn_term_condition.setBackgroundResource(R.drawable.bg_button_cart)
                btn_term_condition.isAllCaps = true

                //Benefit button
                frame_benefit.visibility = View.GONE
                btn_benefit.setTextColor(
                    ContextCompat.getColor(
                        requireContext(), R.color.black
                    )
                )
                btn_benefit.setBackgroundColor(resources.getColor(R.color.colorItemDataPack))

            }

            R.id.button_switch_plan -> {
                SeatelAlertDialog.with(
                    requireContext(),
                    "Are you sure you want to switch to the ${switchPlanName.toString()}? Your current plan's benefits will be active until its expiry date."
                ).setNegativeButton("No", DialogInterface.OnClickListener { dialog, which ->
                    dialog.dismiss()
                }).setPositiveButton("Yes", DialogInterface.OnClickListener { dialog, which ->
                    object : SeatelJSONObjectRequest(context) {
                        override fun getFunctionName(): String {
                            return "switch-plan"
                        }

                        override fun onGetBodyRequest(): String {
                            val obj = JSONObject()
                            obj.put("phoneNumber", getPhoneLogin())
                            obj.put("newPlanCode", newPlanCode)

                            return obj.toString()
                        }

                        override fun getMethod(): Int {
                            return Request.Method.POST
                        }

                    }.setOnErrorListener {
                        SeatelAlertDialog.with(
                            requireContext(), SeatelSuperRequest.getErrorMessageFrom(it)
                        ).show()
                    }.execute {
                        val message = it as JSONObject
                        val mMessage = message.optString("message")
                        SuccessBuyDataPackActivity.launchSwitchPlan(
                            requireContext(), mMessage.toString()
                        )

                    }
                }).show()
            }
        }
    }

    override fun buttonActive(
        dataValuePack: ValuePackTableModel,
        amountMB: String,
        pricetMB: String,
        account: String,
        dayPlan: Int,
        type: String
    ) {
    }

    override fun confirmBuy(
        validity: String, fee: String, data: String, pricePlanCode: String, isAddon: Boolean
    ) {
        when {
            isAddon -> ConfirmBuyDataPackActivity.launch(
                requireContext(), name!!, valueData!!, validity, fee, data, pricePlanCode, true
            )

            else -> ConfirmBuyDataPackActivity.launch(
                requireContext(), name!!, valueData!!, validity, fee, data, pricePlanCode, false
            )
        }
    }

    override fun onRikReaySucceed(rikReayModel: RikReayModel) {
        error_view.visibility = View.GONE
        view_rik_reay.visibility = View.VISIBLE
        if (canChangePlan) {
            button_switch_plan.visibility = View.VISIBLE
        } else button_switch_plan.visibility = View.GONE

        Log.d("rikReay:>>>", "onRikReaySucceed: $rikReayModel")
        layout_product_service_detail.visibility = View.GONE
        mRecyclerOnePlan.visibility = View.GONE
        layout_international_call.visibility = View.GONE

        iv_header_banner.load(rikReayModel.backgroundImg) {
            crossfade(true)

        }
        tv_header_title.text = rikReayModel.mainTitle
        tv_header_subTitle.text = rikReayModel.mainContent[0].title

        /* tv_header_description.text = HtmlCompat.fromHtml(
             rikReayModel.mainContent[0].content,
             HtmlCompat.FROM_HTML_MODE_LEGACY
         )*/
        tv_header_description.settings.javaScriptEnabled = true
        tv_header_description.loadDataWithBaseURL(
            null, rikReayModel.mainContent[0].content, "text/html", "UTF-8", null
        )
        tv_header_description.settings.defaultFontSize = 12

        iv_sub_header.load(rikReayModel.mainContent[1].imgurl) {
            crossfade(true)
        }

        tv_sub_header_subTitle.settings.javaScriptEnabled = true
        tv_sub_header_subTitle.loadDataWithBaseURL(
            null, rikReayModel.mainContent[1].content, "text/html", "UTF-8", null
        )
        tv_sub_header_subTitle.settings.defaultFontSize = 12

        /* tv_sub_header_subTitle.text = HtmlCompat.fromHtml(
             rikReayModel.mainContent[1].content,
             HtmlCompat.FROM_HTML_MODE_LEGACY
         )*/

        tv_content_title.text = rikReayModel.mainContent[2].title

        //    tv_sub_content_title.text = Html.fromHtml(rikReayModel.mainContent[2].content)
        val htmString = rikReayModel.mainContent[2].content
        mWebView.settings.javaScriptEnabled = true
        mWebView.loadDataWithBaseURL(null, htmString, "text/html", "UTF-8", null)
        mWebView.settings.defaultFontSize = 12

        tv_table_title.text = rikReayModel.mainContent[2].tableTitle
        mRecyclerTable.adapter = RikReakDetailAdapter(requireContext(), rikReayModel)
        last_title.text = rikReayModel.mainContent[3].title

        //last_sub_title.text = Html.fromHtml(rikReayModel.mainContent[3].content)
        last_sub_title.settings.javaScriptEnabled = true
        last_sub_title.loadDataWithBaseURL(
            null, rikReayModel.mainContent[3].content, "text/html", "UTF-8", null
        )
        last_sub_title.settings.defaultFontSize = 12

    }

    override fun onRikReayFailed(error: VolleyError) {
        Log.d("rikReay:>>>", "onRikReayFailed: ${error.message}")
        if (activity != null) {
            when (error) {
                is TimeoutError -> {
                    error_view.errorMessage = getString(R.string.connection_timeout)
                    error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
                }

                is NoConnectionError -> {
                    error_view.errorMessage = getString(R.string.message_no_internet)
                    error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
                }

                else -> {
                    error_view.errorMessage = getString(R.string.no_data)
                    error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
                }
            }
        }
    }

}