package com.seatel.mobilehall.ui.home.viewholder

import android.text.TextUtils
import android.view.View
import android.view.View.GONE
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.activity.OrderActivity
import com.seatel.mobilehall.ui.home.adapter.AddOnsAdapter
import com.seatel.mobilehall.ui.home.model.CartModel
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import kotlinx.android.synthetic.main.holder_cart_sim_item.view.*
import java.util.*

class CartSimViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

    fun onBind(
        data: CartModel,
        notifyRow: AddOnsAdapter.MyCartAddOnClick? = null,
        rowPosition: Int? = null
    ) {
        itemView.tv_sim_number.text = data.simCardNumber
        itemView.tv_sim_price.text = String.format(Locale.US, "$%.2f", data.unitPrice)
        itemView.tv_top_up_price.text = String.format(Locale.US, "$%.2f", data.topUpAmount)

        if (data.planSubscription != null)
            if (data.planSubscription.planName != null)
                itemView.tv_plan.text = data.planSubscription.planName
        if (data.isSimDiscount) {
            itemView.tv_sim_card_price.text =
                String.format(Locale.US, "$%.2f", data.discountedCardPrice)
            itemView.tv_total.text = String.format(
                Locale.US,
                "%.2f",
                (data.totalPrice - data.cardPrice) + data.discountedCardPrice
            )
        } else {
            itemView.tv_sim_card_price.text = String.format(Locale.US, "$%.2f", data.cardPrice)
            itemView.tv_total.text = String.format(Locale.US, "%.2f", data.totalPrice)
        }
        itemView.check_box.isChecked = data.isSelected
        itemView.view_add_ons.visibility = View.GONE
        if (data.planSubscription != null) {
            if (data.planSubscription.addOns != null) {
                if (data.planSubscription.addOns!!.isNotEmpty()) {
                    itemView.view_add_ons.visibility = View.VISIBLE

                    val mySimCardAdapter = AddOnsAdapter(
                        itemView.context,
                        data.planSubscription.addOns!!,
                        notifyRow,
                        rowPosition
                    )
                    itemView.rlv_addons.adapter = mySimCardAdapter
                    itemView.rlv_addons.layoutManager = LinearLayoutManager(itemView.context)
                }
            }
        }

        if (TextUtils.isEmpty(OrderingManager.getInstance().simPriceIconUrl))
            itemView.image_view_sim_card_price.setImageResource(R.drawable.ic_sim_price)
        else Glide.with(itemView.context).load(OrderingManager.getInstance().simPriceIconUrl)
            .into(itemView.image_view_sim_card_price)

        if (TextUtils.isEmpty(data.planIcon))
            itemView.image_view_plan.setImageResource(R.drawable.ic_one_plan)
        else Glide.with(itemView.context).load(data.planIcon).into(itemView.image_view_plan)

        if (TextUtils.isEmpty(OrderingManager.getInstance().simIconUrl))
            itemView.image_view_sim.setImageResource(R.drawable.ic_buy_sim)
        else Glide.with(itemView.context).load(OrderingManager.getInstance().simIconUrl)
            .into(itemView.image_view_sim)

        if (TextUtils.isEmpty(OrderingManager.getInstance().topUpIconUrl))
            itemView.image_view_top_up.setImageResource(R.drawable.ic_topup_pink)
        else Glide.with(itemView.context).load(OrderingManager.getInstance().topUpIconUrl)
            .into(itemView.image_view_top_up)

        if (itemView.context is OrderActivity) {
            itemView.layout_total.visibility = GONE
            itemView.check_box.visibility = GONE
        } else {
            val param = FrameLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
            param.topMargin = SeatelUtils.convertDpToPx(itemView.context, 10)
//            param.bottomMargin = if (adapterPosition == count - 1 && (itemView.context as MyCartActivity).getBottomBar().visibility == View.VISIBLE)
//                (itemView.context as MyCartActivity).getBottomBar().height + 0 else 0
            itemView.layoutParams = param
        }
    }
}