package com.seatel.mobilehall.ui.home.viewholder

import android.text.TextUtils
import android.view.View
import android.view.View.GONE
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.ui.home.activity.DeviceDetailActivity
import com.seatel.mobilehall.ui.home.activity.OrderActivity
import com.seatel.mobilehall.ui.home.model.CartModel
import com.seatel.mobilehall.ui.home.model.DeviceDetailViewModel
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import kotlinx.android.synthetic.main.holder_cart_device_item.view.*
import java.util.*

class CartDeviceViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

    fun onBind(data: CartModel) {
        itemView.tv_device_name.text =
            SeatelUtils.toCamelCase(String.format(Locale.US, "%s %s", data.brand, data.model))
        itemView.tv_device_price.text = String.format(Locale.US, "$%.2f", data.unitPrice)
        itemView.tv_total.text = String.format(Locale.US, "%.2f", data.totalPrice)
//        itemView.tv_device_each_price.text = String.format(Locale.US, "$%.2f", data.unitPrice)
        itemView.tv_device_color.text = data.color
        itemView.tv_device_qty.text = String.format(Locale.US, "%d", data.quantity)
        itemView.tv_device_storage.text = String.format(Locale.US, "%dGB", data.storage)
        itemView.check_box.isChecked = data.isSelected

        if (TextUtils.isEmpty(data.thumbnailUrl))
            Glide.with(itemView.context).load(OrderingManager.getInstance().deviceIconUrl)
                .into(itemView.image_view_device)
        else
            Glide.with(itemView.context).load(data.thumbnailUrl).into(itemView.image_view_device)

        if (itemView.context is OrderActivity) {
            itemView.layout_total.visibility = GONE
            itemView.check_box.visibility = GONE
            itemView.image_view_remove.visibility = GONE
            itemView.image_view_add.visibility = GONE
            itemView.tv_device_qty.background = null
            itemView.tv_device_qty.setPadding(0, 0, 0, 0)
        } else {
            val param = FrameLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
            param.topMargin = SeatelUtils.convertDpToPx(itemView.context, 10)
//            param.bottomMargin = if (adapterPosition == count - 1 && (itemView.context as MyCartActivity).getBottomBar().visibility == View.VISIBLE)
//                (itemView.context as MyCartActivity).getBottomBar().height + 0 else 0
            itemView.layoutParams = param

            itemView.layout_go_to_detail.setOnClickListener {
                val dataDeviceDetailViewer = DeviceDetailViewModel()
                dataDeviceDetailViewer.isUpdatedCart = false
                dataDeviceDetailViewer.deviceId = data.deviceUrl
                dataDeviceDetailViewer.deviceColor = data.color
                dataDeviceDetailViewer.deviceColorCode = data.colorId
                dataDeviceDetailViewer.deviceStorage = data.storage
                dataDeviceDetailViewer.devicePrice = data.unitPrice
                dataDeviceDetailViewer.deviceQty = data.quantity
                dataDeviceDetailViewer.cartId = data.id
                dataDeviceDetailViewer.isUpdatedCart = true
                DeviceDetailActivity.lunchWithResult(itemView.context, dataDeviceDetailViewer)
            }
        }

        itemView.image_view_remove.setOnClickListener {
            OrderingManager.getInstance().updateCartItem(itemView.context, data, data.quantity - 1)
        }
        itemView.image_view_add.setOnClickListener {
            if (data.quota > 0 && data.quota < data.quantity + 1) {
                SeatelAlertDialog.with(
                    itemView.context,
                    "${
                        SeatelUtils.translatForDialog(
                            itemView.context,
                            "You can buy only"
                        )
                    } ${data.quota} ${
                        SeatelUtils.translatForDialog(
                            itemView.context,
                            "of this device."
                        )
                    }"
                ).setCancelable(true).show()
                return@setOnClickListener
            }
            OrderingManager.getInstance().updateCartItem(itemView.context, data, data.quantity + 1)
        }
    }
}