package com.seatel.mobilehall.ui.home.fragment

import android.content.Context
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.adapter.OrderSummaryAdapter
import com.seatel.mobilehall.util.manager.OrderingManager
import kotlinx.android.synthetic.main.fragment_order_summary.*
import kotlinx.android.synthetic.main.fragment_order_summary.view.*
import java.util.*

class OrderSummaryFragment : BaseFragment() {

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setFragmentLayout(R.layout.fragment_order_summary)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        if ((OrderingManager.getInstance().claimFreeSim || OrderingManager.getInstance().winPromotionFreeSim))
            view_note_claim_free_sim.visibility = View.VISIBLE
        view.tv_total.text =
            String.format(Locale.US, "%.2f", OrderingManager.getInstance().totalSelectedPrice)
        view.rv_order_summary.layoutManager = LinearLayoutManager(context)
        view.rv_order_summary.adapter = OrderSummaryAdapter(context)
    }
}