package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ProgressBar
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemYesNumberBinding
import com.seatel.mobilehall.databinding.ItemLoadMoreDataBinding
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.model.SimCardPricePurchaseAbleModel
import com.seatel.mobilehall.ui.home.model.YesNumberModel
import com.seatel.mobilehall.util.AppUtils

open class FullNumberAdapter(
    private val mContext: Context,
    private val mFullNumberModels: ArrayList<YesNumberModel>
) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    var isLoadAll = false
    var onItemClickListener: BaseRecyclerAdapter.OnItemClickListener<YesNumberModel>? = null
    var limit = 20
    var mSimPricePurchaseAbleModels = ArrayList<SimCardPricePurchaseAbleModel>()

    companion object {
        const val LOADING_TYPE = 0
        const val ITEM_TYPE = 1
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return if (viewType == ITEM_TYPE) {
            val binding = ItemYesNumberBinding.inflate(LayoutInflater.from(mContext), parent, false)
            ViewHolder(binding)
        } else {
            val binding = ItemLoadMoreDataBinding.inflate(LayoutInflater.from(mContext), parent, false)
            LoadMoreHolder(binding)
        }
    }

    override fun getItemViewType(position: Int): Int {
        return if (position == mFullNumberModels.size) LOADING_TYPE else ITEM_TYPE
    }

    private fun isPurchaseAble(price: Double): SimCardPricePurchaseAbleModel {
        for (c in mSimPricePurchaseAbleModels) {
            if (c.amount.toDouble() == price && c.amount > 0)
                return c
        }
        val default = SimCardPricePurchaseAbleModel()
        default.isPurchasable = true
        return default
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        if (holder is ViewHolder) {
            val numberModel = mFullNumberModels[position]
            holder.bind(numberModel)
        } else if (holder is LoadMoreHolder) {
            holder.bind(isLoadAll, mFullNumberModels.size >= limit)
        }
    }

    override fun getItemCount(): Int {
        return mFullNumberModels.size + 1
    }

    // ViewHolder for item type (YesNumberModel)
    inner class ViewHolder(private val binding: ItemYesNumberBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(numberModel: YesNumberModel) {
            binding.buyYesPhoneNumber.text = numberModel.phoneNumber
            if (isPurchaseAble(numberModel.price).isPurchasable) {
                if (numberModel.discountRate > 0.0) {
                    binding.buyYesNumberPrice.text = AppUtils.decimalFormat().format(numberModel.discountedPrice)
                    binding.buyYesNumberPriceOriginBlack.text = AppUtils.decimalFormat().format(numberModel.price)
                    binding.viewKeepOriginPriceBlack.visibility = View.VISIBLE
                } else {
                    binding.buyYesNumberPrice.text = AppUtils.decimalFormat().format(numberModel.price)
                    binding.viewKeepOriginPriceBlack.visibility = View.INVISIBLE
                }
            } else {
                binding.buyYesNumberPrice.text = mContext.getString(R.string.visit_yes_hub)
                binding.viewKeepOriginPriceBlack.visibility = View.INVISIBLE
            }

            binding.checkBoxBuyYesNumber.visibility = if (numberModel.isChecked) View.VISIBLE else View.INVISIBLE
            binding.root.setBackgroundResource(
                if (numberModel.isChecked) R.drawable.bg_buy_sim_item_select else R.drawable.bg_order_search
            )
            binding.root.setOnClickListener {
                onItemClickListener?.onItemClick(binding.root, adapterPosition, numberModel)
            }
        }
    }

    // ViewHolder for load more item type
    class LoadMoreHolder(private val binding: ItemLoadMoreDataBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(isLoadAll: Boolean, isLimitReached: Boolean) {
            binding.progressbar.visibility = if (!isLoadAll && isLimitReached) View.VISIBLE else View.GONE
        }
    }
}
