package com.seatel.mobilehall.ui.base.adapter

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.GestureDetector
import android.view.MotionEvent
import android.view.View
import android.widget.Filter
import android.widget.Filterable
import com.seatel.mobilehall.ui.home.viewholder.BaseViewHolder

abstract class BaseRecyclerAdapter<T>() : RecyclerView.Adapter<BaseViewHolder<T>>(), Filterable{
    var mData: List<T> = ArrayList()
    var mDataDisplay: List<T> = ArrayList()
    var onItemClickListener: OnItemClickListener<T>? = null

    constructor(mData: List<T>) : this() {
        this.mData = mData
        this.mDataDisplay = mData
    }

    companion object {
        const val ITEM_HEADER = 0
        const val ITEM_CONTENT = 1
    }

    fun setData(mData: List<T>) {
        this.mData = mData
        notifyDataSetChanged()
    }

    fun getItem(): List<T> {
        return mDataDisplay
    }

    open fun getItem(position: Int): T {
        return mDataDisplay[position]
    }

    override fun getItemCount() = mDataDisplay.size

    override fun onBindViewHolder(holder: BaseViewHolder<T>, position: Int) {
        holder.itemView.setOnClickListener {
            onItemClickListener?.onItemClick(holder.itemView, holder.adapterPosition, getItem(holder.adapterPosition))
        }
        holder.binData(this)
    }

    override fun onViewRecycled(holder: BaseViewHolder<T>) {
        super.onViewRecycled(holder)
        holder.onViewRecycler()
    }

    interface OnItemClickListener<in T> {
        fun onItemClick(v: View, position: Int, data: T)

        fun onItemLongClick(position: Int, data: T){}

        fun onChildViewClick(position: Int, data: T){}
    }

    @Suppress("UNCHECKED_CAST")
    /**
     * Single Click
     */
    class RecyclerTouchListener<T>(context: Context, recycleView: RecyclerView, private val mItemClickListener: OnItemClickListener<T>) : RecyclerView.OnItemTouchListener {
        private val mGestureDetector: GestureDetector

        init {
            mGestureDetector = GestureDetector(context, object : GestureDetector.SimpleOnGestureListener() {
                override fun onSingleTapUp(e: MotionEvent): Boolean {
                    return true
                }

                override fun onLongPress(e: MotionEvent) {
                    val child = recycleView.findChildViewUnder(e.x, e.y)
                    if (child != null && true && recycleView.adapter is BaseRecyclerAdapter<*>) {
                        val baseAdapter = recycleView.adapter as BaseRecyclerAdapter<*>
                        mItemClickListener.onItemLongClick(recycleView.getChildAdapterPosition(child), baseAdapter.getItem(recycleView.getChildAdapterPosition(child)) as T)
                    }
                }
            })
        }

        override fun onInterceptTouchEvent(rv: RecyclerView, e: MotionEvent): Boolean {
            val child = rv.findChildViewUnder(e.x, e.y)
            if (child != null && mGestureDetector.onTouchEvent(e) && rv.adapter is BaseRecyclerAdapter<*>) {
                val baseAdapter = rv.adapter as BaseRecyclerAdapter<*>
                mItemClickListener.onItemClick(child, rv.getChildAdapterPosition(child), (baseAdapter.getItem(rv.getChildAdapterPosition(child)) as T?)!!)
            }
            return false
        }

        override fun onTouchEvent(rv: RecyclerView, e: MotionEvent) {

        }

        override fun onRequestDisallowInterceptTouchEvent(disallowIntercept: Boolean) {

        }
    }

    override fun getFilter(): Filter? {
        return null
    }
}
