package com.seatel.mobilehall.ui.home.activity

import android.annotation.SuppressLint
import android.os.Bundle
import android.widget.RelativeLayout
import androidx.coordinatorlayout.widget.CoordinatorLayout
import androidx.core.content.ContextCompat
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityDataPackDetailBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.BottomNavigationBehavior

@SuppressLint("Registered")
open class BaseProductAndServiceActivity : BaseActivity<ActivityDataPackDetailBinding>(),
    SwipeRefreshLayout.OnRefreshListener {


    override fun getViewBinding(): ActivityDataPackDetailBinding {
        return ActivityDataPackDetailBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //    setContentView(R.layout.activity_data_pack_detail)
        activityEnterRightAnimation()
        if (isShowAddToCardButton()) {
            addShowButtonFooter()
        }

        binding.swipeRefreshLayout.setColorSchemeColors(
            ContextCompat.getColor(
                this,
                R.color.colorPrimary
            )
        )
        //swipe_refresh_layout.setOnRefreshListener(this)
        binding.swipeRefreshLayout.isRefreshing = false
        binding.swipeRefreshLayout.isEnabled = false
    }

    private fun addShowButtonFooter() {
        val navigation = findViewById<RelativeLayout>(R.id.data_pack_bottom_navigation)
        val navigationBackground =
            findViewById<RelativeLayout>(R.id.data_pack_bottom_navigation_background)
        val layoutParams = navigation.layoutParams as CoordinatorLayout.LayoutParams
        val layoutParamsBackground =
            navigationBackground.layoutParams as CoordinatorLayout.LayoutParams

        binding.scrollDataPack.viewTreeObserver.addOnGlobalLayoutListener {
            val bottomNavigationBehavior = BottomNavigationBehavior(440)
            val bottomNavigationBehaviorBackground = BottomNavigationBehavior(300)
            bottomNavigationBehavior.showBottomNavigationView(navigation)
            bottomNavigationBehaviorBackground.showBottomNavigationView(navigationBackground)
            if (getHeight(binding.scrollDataPack) < getHeight(binding.recyclerViewProductService) + 30) {

                layoutParams.behavior = bottomNavigationBehavior
                layoutParamsBackground.behavior = bottomNavigationBehaviorBackground
            }
            binding.scrollDataPack.viewTreeObserver.removeOnGlobalLayoutListener { this }
        }
    }

    fun setShowButton(show: Boolean) {
        addShowButtonFooter()
    }

    open fun isShowAddToCardButton(): Boolean {
        return true
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.data_pack_title)
    }

    override fun onRefresh() {
    }


}