package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import android.util.Log
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.ui.home.interactor.ProfileInteractor
import com.seatel.mobilehall.ui.login.model.ProfileModel
import com.seatel.mobilehall.ui.login.model.PromotionHomeModel
import com.seatel.mobilehall.util.ScanMRZSharePref
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import org.json.JSONObject

class ProfilePresenter(private var mContext: Context) : ProfileInteractor.Presenter {

    private var profileView: ProfileInteractor.View? = null// mContext as ProfileInteractor.View
    private var objectRequest: SeatelJSONObjectRequest? = null

    override fun loadData(phoneNumber: String) {
        profileView = mContext as ProfileInteractor.View
        getProfileRequest(phoneNumber).setOnErrorListener { error ->
            profileView?.onLoadDataFailed(error)
        }.setOnResponseListener { response ->
            profileView?.onLoadDataSucceed(getProfileModel(response as JSONObject))
        }.execute()

    }

    fun onDestroy() {
        profileView = null
    }

    private fun getProfileModel(response: JSONObject): ProfileModel {

        val profileModel = ProfileModel()
        profileModel.certType = response.optString("certType")
        profileModel.certNumber = response.optString("certNumber")
        profileModel.custName = response.optString("custName")
        profileModel.msisdn = response.optString("mSISDN")
        profileModel.email = response.optString("email")
        profileModel.imageUrl = response.optString("profilePicture")
        profileModel.isSnowfall = response.optBoolean("snowfall", false)
        profileModel.isClaimFreeSim = response.optBoolean("hasPromotion", false)
        profileModel.isForceUpdate = response.optBoolean("forceUpdate", false)
        profileModel.isCanUpdateProfile = response.optBoolean("canUpdateProfile", false)
        profileModel.message = response.optString("message")
        profileModel.isOffnetNumber =
            SeatelUtils.checkIsNoneSeatelType(response.optString("type", ""))
        if (response.has("cardPrice"))
            OrderingManager.getInstance().simPriceDefault = response.optDouble("cardPrice", 0.5)
        //  SeatelSharePreferences.getInstance(mContext).noneSeatelNumber = profileModel.isOffnetNumber
        if (response.has("promotions")) {
            val dataPromo = response.optJSONArray("promotions")
            val promoList: ArrayList<PromotionHomeModel> = ArrayList()
            for (i in 0..(dataPromo.length() - 1)) {
                promoList.add(
                    PromotionHomeModel(
                        dataPromo.optJSONObject(i).optString("_id"),
                        dataPromo.optJSONObject(i).optString("name"),
                        dataPromo.optJSONObject(i).optString("code")
                    )
                )
            }
            profileModel.promotions = promoList
        }
        if (response.has("orderIds")) {
            val dataId = response.optJSONArray("orderIds")
            val idList: ArrayList<Int> = ArrayList()
            for (i in 0..(dataId.length() - 1)) {
                idList.add(dataId.optInt(i))
            }
            profileModel.orderIdUnSuccess = idList
        }
        if (response.has("mrzKey"))
            ScanMRZSharePref.getConstant(mContext).scanMrzKey = response.optString("mrzKey")
        if (response.has("shipmentInsuranceRate"))
            OrderingManager.getInstance().shipmentInsuranceRate =
                response.optDouble("shipmentInsuranceRate", 0.0)
        SeatelSharePreferences.getInstance(mContext)?.setUserInfo(Gson().toJson(profileModel))


        Log.e("profile", profileModel.toString())
        return profileModel
    }

    private fun getProfileRequest(phoneNumber: String): SeatelJSONObjectRequest {
        objectRequest?.cancel()
        objectRequest = object : SeatelJSONObjectRequest(mContext) {


            override fun getFunctionName(): String {
                return "v2/seatel/profile?phoneNumber=$phoneNumber"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }


        }
        return objectRequest!!
    }
}