package com.seatel.mobilehall.ui.profile.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.profile.interactor.ChangeLanguageInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject

class ChangeLanguagePresenter(
    private var mContext: Context,
    private var mSettingLanguageView: ChangeLanguageInteractor.View
) : ChangeLanguageInteractor.Presenter {

    override fun onPostUpdatedLangauge(phoneNumber: String, langCode: String) {
        postForgotPassRequest(phoneNumber, langCode).setOnErrorListener { error ->
            mSettingLanguageView.onPostUpdatedLangaugeFailed(error)
        }.setOnResponseListener {
            mSettingLanguageView.onPostUpdatedLangaugeSucceed()
        }.execute()
    }

    private fun postForgotPassRequest(
        phoneNumber: String,
        langCode: String
    ): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return Constant.CHANGE_LANGUAGE
            }

            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("phoneNumber", phoneNumber)
                    data.put("lang", langCode)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

        }
    }
}