package com.seatel.mobilehall.util.request

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.home.model.CartModel
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject

class UpdateCartRequest(context: Context?) : SeatelJSONObjectRequest(context) {

    private var phoneNumber = ""
    private var qty = 0
    private var cartItemModel = CartModel()

    override fun getFunctionName(): String {
        return Constant.UPDATE_CART_ITEMS + cartItemModel.id
    }

    override fun onGetBodyRequest(): String {
        try {
            val objectRequest = JSONObject()
            val objectItem = JSONObject()
            objectItem.put("type", cartItemModel.type)
            objectItem.put("quantity", qty)
            objectItem.put("topUpAmount", cartItemModel.topUpAmount)
            objectItem.put("simCardNumber", cartItemModel.simCardNumber)
            objectItem.put("deviceUrl", cartItemModel.deviceUrl)
            objectItem.put("color", cartItemModel.color)
            objectItem.put("colorId", cartItemModel.colorId)
            objectItem.put("storage", cartItemModel.storage)
            objectItem.put("scratchCardAmount", cartItemModel.scratchCardAmount)

            objectRequest.put("phoneNumber", phoneNumber)
            objectRequest.put("item", objectItem)
            return objectRequest.toString()
        } catch (e: JSONException) {
            return ""
        }
    }

    fun phoneNumber(phoneNumber: String): UpdateCartRequest {
        this.phoneNumber = phoneNumber
        return this
    }

    fun qty(qty: Int): UpdateCartRequest {
        this.qty = qty
        return this
    }

    fun cartItemModel(cartItemModel: CartModel): UpdateCartRequest {
        this.cartItemModel = cartItemModel
        return this
    }

    override fun getMethod(): Int {
        return Request.Method.PUT
    }


}