package com.seatel.mobilehall.util.customview

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.LinearLayout
import androidx.core.content.ContextCompat
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ViewOrderSectionBinding

class OrderSectionView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : LinearLayout(context, attrs, defStyleAttr) {

    private var binding: ViewOrderSectionBinding? = null

    init {
        val inflater = LayoutInflater.from(context)
        binding = ViewOrderSectionBinding.inflate(inflater, this, true)
    }

    // Clean up to avoid memory leaks
    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        binding = null
    }

    fun setViewForClaimFreeSim() {
        binding?.frameFour?.visibility = View.GONE
    }

    fun setSection(section: Int) {
        // Set all sections to grey by default
        binding?.apply {
            frameTwo.setBackgroundColor(ContextCompat.getColor(context, R.color.section_grey))
            frameThree.setBackgroundColor(ContextCompat.getColor(context, R.color.section_grey))
            frameFour.setBackgroundColor(ContextCompat.getColor(context, R.color.section_grey))

            imageViewTwo.setImageResource(R.drawable.ic_section_2_grey)
            imageViewThree.setImageResource(R.drawable.ic_section_3_grey)
            imageViewFour.setImageResource(R.drawable.ic_section_4_grey)

            textViewTwo.setTextColor(ContextCompat.getColor(context, R.color.section_grey))
            textViewThree.setTextColor(ContextCompat.getColor(context, R.color.section_grey))
            textViewFour.setTextColor(ContextCompat.getColor(context, R.color.section_grey))
        }

        // Highlight sections based on the 'section' value
        if (section > 1) {
            binding?.apply {
                frameTwo.setBackgroundColor(ContextCompat.getColor(context, R.color.colorPrimary))
                imageViewTwo.setImageResource(R.drawable.ic_section_2_primary)
                textViewTwo.setTextColor(ContextCompat.getColor(context, R.color.colorPrimary))
            }
        }
        if (section > 2) {
            binding?.apply {
                frameThree.setBackgroundColor(ContextCompat.getColor(context, R.color.colorPrimary))
                imageViewThree.setImageResource(R.drawable.ic_section_3_primary)
                textViewThree.setTextColor(ContextCompat.getColor(context, R.color.colorPrimary))
            }
        }
        if (section > 3) {
            binding?.apply {
                frameFour.setBackgroundColor(ContextCompat.getColor(context, R.color.colorPrimary))
                imageViewFour.setImageResource(R.drawable.ic_section_4_primary)
                textViewFour.setTextColor(ContextCompat.getColor(context, R.color.colorPrimary))
            }
        }
    }
}
