package com.seatel.mobilehall.util

import android.content.Context
import android.graphics.Typeface
import com.seatel.mobilehall.util.lang.LanguageManager.Companion.getInstance
import java.util.*

object FontCache {
    private val fontCache = Hashtable<String, Typeface>()

    operator fun get(context: Context, name: String): Typeface {
        var tf = fontCache[name]
        if (tf == null) {
            tf = try {
                Typeface.createFromAsset(context.assets, name)
            } catch (e: Exception) {
                return null!!
            }
            fontCache[name] = tf
        }
        return tf!!
    }

   fun getFont(context: Context?, textStyle: Int): String {
        return when (getInstance(context!!).getLanguageCode()) {
            Constant.KHMER -> {
                when (textStyle) {
                    Typeface.BOLD -> "fonts/NotoSansKhmerUI-Bold.ttf"
                    else -> "fonts/NotoSansKhmer-Regular.ttf"
                }
            }
            Constant.ENGLISH -> {
                when (textStyle) {
                    Typeface.BOLD -> "fonts/source-sans-pro-bold.ttf"
                    Typeface.ITALIC -> "fonts/source-sans-pro-italic.ttf"
                    else -> "fonts/source-sans-pro-regular.ttf"
                }
            }
            Constant.CHINESE -> {
                "fonts/Microsoft-YaHei.ttf"
            }
            else -> {
                "fonts/source-sans-pro-regular.ttf"
            }
        }
    }
}