package com.seatel.mobilehall.util;

import android.content.Context;
import android.os.Bundle;
import android.widget.Button;

import com.google.firebase.analytics.FirebaseAnalytics;

public class FirebaseAnalyticsUtil {

    private final FirebaseAnalytics mFirebaseAnalytics;
    private static FirebaseAnalyticsUtil INSTANCE = null;

    public static FirebaseAnalyticsUtil getInstance(Context context) {
        if (INSTANCE == null)
            INSTANCE = new FirebaseAnalyticsUtil(context);
        return INSTANCE;
    }

    private FirebaseAnalyticsUtil(Context context) {
        mFirebaseAnalytics = FirebaseAnalytics.getInstance(context);
    }

    public void logButton(String buttonAction) {
        Bundle bundle = new Bundle();
        bundle.putString(Constant.BUTTON, buttonAction);
        mFirebaseAnalytics.logEvent(FirebaseAnalytics.Event.SELECT_CONTENT, bundle);
    }

    public void logCustomEvent(String buttonAction) {
        Bundle params = new Bundle();
        //params.putString(Constant.SeaTelAnalytics.EventName.CLICK, buttonAction);
        mFirebaseAnalytics.logEvent(buttonAction, params);
    }

    public void logDeviceModel(String buttonAction) {
        Bundle params = new Bundle();
        params.putString(Constant.BUTTON, buttonAction);
        mFirebaseAnalytics.logEvent(buttonAction, params);
    }

    public void logClass(Context context) {
        context.getClass().getSimpleName();
    }

    public void logButtonId(Button button) {
        button.getText();
    }

    public void getButtonId(Button buttonID) {
        buttonID.getId();
    }
}
