package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.webkit.WebViewClient
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.databinding.ActivityYesMemberTermConditionBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity

class YesMemberTermConditionActivity : BaseActivity<ActivityYesMemberTermConditionBinding>() {


    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, YesMemberTermConditionActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityYesMemberTermConditionBinding {
        return ActivityYesMemberTermConditionBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        //    getTermCondition()
        binding.ivBack.setOnClickListener {
            onBackPressed()
        }

        loadTermsInWebView()

    }


    private fun loadTermsInWebView() {
        binding.wvTermCondition.settings.apply {
            javaScriptEnabled = true  // Enable JavaScript (if needed)
            domStorageEnabled = true  // Enable local storage (if required)
            loadsImagesAutomatically = true
            useWideViewPort = true
        }

        binding.wvTermCondition.webViewClient = WebViewClient() // Prevent opening in a browser

        // Load API URL directly in WebView
        val url = BuildConfig.BASE_URL + "yes-member-term"
        binding.wvTermCondition.loadUrl(url)
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }
}