package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import coil.load
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivitySelectShopBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.SelectShopAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.SelectShopInteractor
import com.seatel.mobilehall.ui.yes_member.model.SelectShopModel
import com.seatel.mobilehall.ui.yes_member.presenter.SelectShopPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class SelectShopActivity : BaseActivity<ActivitySelectShopBinding>(),
    SelectShopInteractor.View {

    companion object {
        fun launch(context: Context, id: String) {
            val intent = Intent(context, SelectShopActivity::class.java)
            intent.putExtra("id", id)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivitySelectShopBinding {
        return ActivitySelectShopBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        SelectShopPresenter(this, this).getSelectShop(
            intent.getStringExtra("id").toString(),
            getPhoneLogin()
        )
    }

    override fun responseSelectShopSucceed(rewardDetail: SelectShopModel) {
        Log.d("TAG::>>>", "responseRewardDetailSucceed: $rewardDetail")

        binding.ivRewardDetailImg.load(rewardDetail.imageUrl) {
            crossfade(true)
        }
        binding.recyclerShop.adapter = SelectShopAdapter(this, rewardDetail.availableShops) {
            RewardsDetailActivity.launch(
                this,
                rewardDetail.imageUrl,
                rewardDetail.name,
                rewardDetail.exchangePoint.toString(),
                rewardDetail.description,
                rewardDetail._id,
                it.shop.toString()
            )
        }
    }

    override fun responseSelectShopFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }


    override fun getStringToolbarTitle(): String? {
        return "Select Shop"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }


}