package com.seatel.mobilehall.ui.profile.presenter

import android.content.Context
import android.text.TextUtils
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.profile.interactor.MySubScriptionInteractor
import com.seatel.mobilehall.ui.profile.model.*
import org.json.JSONObject

class MySubscriptionPresenter(
    private var mContext: Context,
    private var mySubView: MySubScriptionInteractor.View
) : MySubScriptionInteractor.Presenter {

    //  private var requestSubscription: SeatelJSONObjectRequest? = null

    override fun onLoadData(phoneNumber: String) {

        getMySubscriptionRequest(phoneNumber).setOnErrorListener { error ->
            mySubView.onLoadDataFailed(error)
        }.setOnResponseListener { response ->
            mySubView.onLoadDataSucceed(getMySubModel(response as JSONObject))
        }.execute()
    }

    fun onDestroy() {
        //   mySubView = null
    }

    private fun getMySubModel(jsonObject: JSONObject): MySubscriptionModel {
        val mySubModel = MySubscriptionModel()
        val myDataPlan = ArrayList<DataPlansModel>()
        val balancesListPostPaid = ArrayList<BalancesPostPaidModel>()
        val installmentPlanModels = ArrayList<InstallmentPlanModel>()
        val deviceInstallmentModels = ArrayList<DeviceInstallment>()
        val mPromotions = ArrayList<Promotions>()
//        val subscriptionPlansData = ArrayList<MySubscriptionModel>()

        mySubModel.planCode = jsonObject.optString("planCode")
        mySubModel.balance = jsonObject.optString("balance")
        mySubModel.totalBalance = jsonObject.optDouble("totalBalance", 0.0)
        mySubModel.usedBalance = jsonObject.optDouble("usedBalance", 0.0)
        mySubModel.planName = jsonObject.optString("planName")
        mySubModel.name = jsonObject.optString("name")
        mySubModel.planIcon = jsonObject.optString("planIcon")
        mySubModel.expiredDate = jsonObject.optString("expiredDate")
        mySubModel.subscribedDate = jsonObject.optString("subscribedDate")
        mySubModel.showUnlimitedVoiceAndSMS =
            jsonObject.optBoolean("showUnlimitedVoiceAndSMS", false)
        mySubModel.showBalance = jsonObject.optBoolean("showBalance", false)
        mySubModel.useGaugeText = jsonObject.optBoolean("useGaugeText", false)
        mySubModel.touristExpiredDate = jsonObject.optString("touristExpiredDate")
        mySubModel.touristSubscribedDate = jsonObject.optString("touristSubscribedDate")
        mySubModel.mainGaugeText = jsonObject.optString("mainGaugeText")

        val jsonArray = jsonObject.getJSONArray("dataPlans")
        val balanceArray = jsonObject.getJSONArray("postPaidBalances")
        val installmentPlan = jsonObject.getJSONArray("instalmentPlan")
        val deviceInstallment = jsonObject.getJSONArray("deviceInstallment")
        val promotion = jsonObject.getJSONArray("promotions")
//        val subscriptionPlansArray = jsonObject.getJSONArray("subscriptionPlans")
        val dataPlanLength = jsonArray.length()

        for (i in 0 until dataPlanLength) {

            val dataPlanModel = DataPlansModel()
            dataPlanModel.code = jsonArray.optJSONObject(i).optString("code")
            dataPlanModel.name = jsonArray.optJSONObject(i).optString("name")
            dataPlanModel.icon = jsonArray.optJSONObject(i).optString("icon")
            dataPlanModel.useGaugeText =
                jsonArray.optJSONObject(i).optBoolean("useGaugeText", false)
            dataPlanModel.mainGaugeText = jsonArray.optJSONObject(i).optString("mainGaugeText", "")
            dataPlanModel.buyMore = jsonArray.optJSONObject(i).optBoolean("buyMore", false)

            dataPlanModel.subscribedDate = jsonArray.optJSONObject(i).optString("subscribedDate")
            dataPlanModel.expiredDate = jsonArray.optJSONObject(i).optString("expiredDate")
            dataPlanModel.remainingData = jsonArray.optJSONObject(i).optDouble("remainingData")
            dataPlanModel.remainingValue = jsonArray.optJSONObject(i).optDouble("remainingValue")
            dataPlanModel.totalData = jsonArray.optJSONObject(i).optDouble("totalData")
            dataPlanModel.totalValue = jsonArray.optJSONObject(i).optDouble("totalValue")
            dataPlanModel.expandable = jsonArray.optJSONObject(i).optBoolean("expandable", false)
            if (dataPlanModel.expandable) {
                val internetPackList = if (TextUtils.equals(dataPlanModel.code, "value-pack"))
                    jsonArray.optJSONObject(i).getJSONArray("valueList")
                else
                    jsonArray.optJSONObject(i).getJSONArray("dataPlanList")

                val listOfInternetPack = ArrayList<InternetPackListModel>()
                for (j in 0 until internetPackList.length()) {
                    val internetPackListModel = InternetPackListModel()
                    internetPackListModel.expiredDate =
                        internetPackList.optJSONObject(j).optString("expiredDate")
                    internetPackListModel.subscribedDate =
                        internetPackList.optJSONObject(j).optString("subscribedDate")
                    if (TextUtils.equals(dataPlanModel.code, "value-pack")) {
                        internetPackListModel.name =
                            internetPackList.optJSONObject(j).optString("name")
                        internetPackListModel.description =
                            internetPackList.optJSONObject(j).optString("description")
                        internetPackListModel.exoandable =
                            internetPackList.optJSONObject(j).optBoolean("expandable")
                        internetPackListModel.valuePackRow = true
                        internetPackListModel.remainingData =
                            internetPackList.optJSONObject(j).optDouble("remainingValue")
                        if (internetPackListModel.exoandable) {
                            val listSub = internetPackList.optJSONObject(j).getJSONArray("list")
                            val listSubValuePack = ArrayList<InternetPackListModel>()
                            for (k in 0 until listSub.length()) {
                                val subModel = InternetPackListModel()
                                subModel.name = listSub.optJSONObject(k).optString("name")
                                subModel.remainingData =
                                    listSub.optJSONObject(k).optDouble("remainingValue")
                                listSubValuePack.add(subModel)
                            }
                            if (listSub.length() > 0)
                                internetPackListModel.listSub = listSubValuePack
                        }
                    } else internetPackListModel.remainingData =
                        internetPackList.optJSONObject(j).optDouble("remainingData")
                    listOfInternetPack.add(internetPackListModel)
                }
                dataPlanModel.internetPackList = listOfInternetPack
            }
            myDataPlan.add(dataPlanModel)

        }

        for (i in 0 until balanceArray.length()) {

            val balancesPostPaidModel = BalancesPostPaidModel()
            balancesPostPaidModel.name = balanceArray.optJSONObject(i).optString("name")
            balancesPostPaidModel.balance = balanceArray.optJSONObject(i).optDouble("balance", 0.0)
            balancesPostPaidModel.totalBalance =
                balanceArray.optJSONObject(i).optDouble("totalBalance", 0.0)
            balancesPostPaidModel.remainingBalance =
                balanceArray.optJSONObject(i).optDouble("remainingBalance", 0.0)
            balancesPostPaidModel.subscribedDate =
                balanceArray.optJSONObject(i).optString("subscribedDate", "")
            balancesPostPaidModel.renewDate =
                balanceArray.optJSONObject(i).optString("renewDate", "")
            balancesPostPaidModel.expiredDate =
                balanceArray.optJSONObject(i).optString("expiredDate", "")
            balancesPostPaidModel.topupBalanceRow = false
            if (balanceArray.optJSONObject(i).has("balance"))
                balancesPostPaidModel.topupBalanceRow = true
            balancesListPostPaid.add(balancesPostPaidModel)

        }
        for (i in 0 until installmentPlan.length()) {

            val installmentPlanModel = InstallmentPlanModel()
            installmentPlanModel.name = installmentPlan.optJSONObject(i).optString("name")
            installmentPlanModel.code = installmentPlan.optJSONObject(i).optString("code")
            installmentPlanModel.totalAmount =
                installmentPlan.optJSONObject(i).optDouble("totalAmount", 0.0)
            installmentPlanModel.subscribedDate =
                installmentPlan.optJSONObject(i).optString("subscribedDate")
            installmentPlanModel.expiredDate =
                installmentPlan.optJSONObject(i).optString("expiredDate")
            installmentPlanModel.remainingInstallment =
                installmentPlan.optJSONObject(i).optDouble("remainingInstallment", 0.0)
            installmentPlanModel.icon = installmentPlan.optJSONObject(i).optString("icon")
            installmentPlanModels.add(installmentPlanModel)

        }
        for (i in 0 until deviceInstallment.length()) {

            val deviceInstallmentModel = DeviceInstallment()
            deviceInstallmentModel.name = deviceInstallment.optJSONObject(i).optString("name")
            deviceInstallmentModel.code = deviceInstallment.optJSONObject(i).optString("code")
            deviceInstallmentModel.totalMonth =
                deviceInstallment.optJSONObject(i).optInt("totalMonth", 0)
            deviceInstallmentModel.subscribedDate =
                deviceInstallment.optJSONObject(i).optString("subscribedDate")
            deviceInstallmentModel.expiredDate =
                deviceInstallment.optJSONObject(i).optString("expiredDate")
            deviceInstallmentModel.remainingMonth =
                deviceInstallment.optJSONObject(i).optInt("remainingMonth", 0)
            deviceInstallmentModel.devicePrice =
                deviceInstallment.optJSONObject(i).optDouble("devicePrice")
            deviceInstallmentModels.add(deviceInstallmentModel)

        }

        for (i in 0 until promotion.length()) {
            val promotionModel = Promotions()
            promotionModel.planName = promotion.optJSONObject(i).optString("planName")
            promotionModel.type = promotion.optJSONObject(i).optString("type")
            promotionModel.remainingMonth = promotion.optJSONObject(i).optInt("remainingMonth", 0)
            promotionModel.remainingData =
                promotion.optJSONObject(i).optDouble("remainingData", 0.0)
            promotionModel.subscribedOn = promotion.optJSONObject(i).optString("subscribedOn")
            promotionModel.expOn = promotion.optJSONObject(i).optString("expOn")
            promotionModel.totalMonth = promotion.optJSONObject(i).optInt("totalMonth", 0)
            promotionModel.totalData = promotion.optJSONObject(i).optDouble("totalData", 0.0)
            mPromotions.add(promotionModel)

        }

        mySubModel.dataPlans = myDataPlan
        mySubModel.balancesPostPaid = balancesListPostPaid
        mySubModel.installmentPlanModels = installmentPlanModels
        mySubModel.deviceInstallment = deviceInstallmentModels
        mySubModel.promotions = mPromotions

//        if(subscriptionPlansArray.length() > 0) {
//            for (i in 0 until subscriptionPlansArray.length()) {
//
//                val subscriptionPlansModel = MySubscriptionModel()
//
//                subscriptionPlansModel.planCode = subscriptionPlansArray.optJSONObject(i).optString("planCode")
//                subscriptionPlansModel.balance = subscriptionPlansArray.optJSONObject(i).optString("balance")
//                subscriptionPlansModel.planName = subscriptionPlansArray.optJSONObject(i).optString("planName")
//                subscriptionPlansModel.planIcon = subscriptionPlansArray.optJSONObject(i).optString("planIcon")
//                subscriptionPlansModel.expiredDate = subscriptionPlansArray.optJSONObject(i).optString("expiredDate")
//                subscriptionPlansModel.subscribedDate = subscriptionPlansArray.optJSONObject(i).optString("subscribedDate")
//                subscriptionPlansModel.showUnlimitedVoiceAndSMS = mySubModel.showUnlimitedVoiceAndSMS
//                subscriptionPlansData.add(subscriptionPlansModel)
//            }
//            mySubModel.subscriptionPlans = subscriptionPlansData
//        }

        return mySubModel
    }

    private fun getMySubscriptionRequest(phoneNumber: String): SeatelJSONObjectRequest {

        //   requestSubscription?.cancel()
        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return "seatel/subscriptions?phoneNumber=$phoneNumber"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
        //   return requestSubscription!!
    }
}