package com.seatel.mobilehall.ui.home.model;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.clustering.ClusterItem;

public class ShopLocation implements ClusterItem {

    public final String name;
    public final int iconPin;
    private final LatLng mPosition;
    private String mAddress = "";
    private String mContactNumber = "";
    private String mHoursWork = "";
    private String mId = "";
    private String mLocalArea = "";
    private double latitude = 0.0;
    private double longitude = 0.0;

    public ShopLocation(String name, int iconPin, LatLng mPosition, String address, String contactNumber, String hoursWork, String id, double latMap, double longMap, String LocalArea) {
        this.name = name;
        this.iconPin = iconPin;
        this.mPosition = mPosition;
        this.mAddress = address;
        this.mContactNumber = contactNumber;
        this.mHoursWork = hoursWork;
        this.mId = id;
        this.latitude = latMap;
        this.longitude = longMap;
        this.mLocalArea = mLocalArea;
    }

    public String getLocalArea() {
        return mLocalArea;
    }

    public void setLocalArea(String mLocalArea) {
        this.mLocalArea = mLocalArea;
    }

    public double getLongitude() {
        return longitude;
    }

    public double getLatitude() {
        return latitude;
    }

    public String getId() {
        return mId;
    }

    public String getAddress() {
        return mAddress;
    }

    public String getHoursWork() {
        return mHoursWork;
    }

    public String getContactNumber() {
        return mContactNumber;
    }

    public String getName() {
        return name;
    }

    @Override
    public LatLng getPosition() {
        return mPosition;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getSnippet() {
        return null;
    }
}
