package com.seatel.mobilehall.ui.home.fragment

import android.content.Context
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.adapter.OrderSummaryAdapter
import com.seatel.mobilehall.util.manager.OrderingManager
import com.seatel.mobilehall.databinding.FragmentOrderSummaryBinding
import java.util.*

class OrderSummaryFragment : BaseFragment() {

    // ViewBinding reference
    private var _binding: FragmentOrderSummaryBinding? = null
    private val binding get() = _binding!!

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setFragmentLayout(R.layout.fragment_order_summary)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        // Initialize ViewBinding
        _binding = FragmentOrderSummaryBinding.bind(view)

        // Show/hide claim free sim note based on conditions
        if ((OrderingManager.getInstance().claimFreeSim || OrderingManager.getInstance().winPromotionFreeSim)) {
            binding.viewNoteClaimFreeSim.visibility = View.VISIBLE
        }

        // Set the total price text
        binding.tvTotal.text = String.format(Locale.US, "%.2f", OrderingManager.getInstance().totalSelectedPrice)

        // Set up RecyclerView
        binding.rvOrderSummary.layoutManager = LinearLayoutManager(context)
        binding.rvOrderSummary.adapter = OrderSummaryAdapter(context)
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null  // Avoid memory leaks by clearing the reference
    }
}
