package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.animation.AnimationUtils
import android.widget.LinearLayout
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.interactor.ProductServiceButtonClick
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.ui.login.activity.LoginActivity
import com.seatel.mobilehall.util.customview.CustomButton

class LoyKobAddOnAdapter(
    private var context: Context,
    private var canSubscribe: Boolean,
    private var addOnList: List<ValuePackTableModel>,
    private var productServiceListener: ProductServiceButtonClick,
    private var getMainPhoneLogin: String
) :
    BaseAdapter<LoyKobAddOnAdapter.ViewHolder>() {

    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        val mFee = itemView.findViewById<TextView>(R.id.btn_fee)
        val mData = itemView.findViewById<TextView>(R.id.btn_data)
        val callMin = itemView.findViewById<CustomButton>(R.id.btn_call_min)
        val callSms = itemView.findViewById<CustomButton>(R.id.btn_call_sms)
        val mValidity = itemView.findViewById<TextView>(R.id.btn_validity)
        val mActivateCode = itemView.findViewById<TextView>(R.id.btn_activation_code)
        val mActivate = itemView.findViewById<CustomButton>(R.id.btn_activation)
        val btnActivate = itemView.findViewById<LinearLayout>(R.id.button_activation)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(context).inflate(R.layout.item_loy_kob_add_on, parent, false)
        )
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        setMyAnimation(
            holder.itemView,
            position,
            AnimationUtils.loadAnimation(context, R.anim.anim_recycler_item_horizontal)
        )
        val mAddOnList = addOnList[position]

        holder.mFee.text = mAddOnList.valuePrice
        var callSmsData:String = ""
        mAddOnList.callsmsList.forEach {
            callSmsData = it.toString()
        }
        holder.mData.text = mAddOnList.priceChange.toString() + callSmsData
      //  holder.mValidity.text = mAddOnList.validityDate
        holder.mActivateCode.text = mAddOnList.activation
        /*if (mAddOnList.callsmsList != null && mAddOnList.callsmsList.size > 0) {
            if (mAddOnList.callsmsList.size == 1) {
                holder.callMin.text = mAddOnList.callsmsList[0]
            } else {
                holder.callSms.visibility = View.VISIBLE
                holder.callMin.text = mAddOnList.callsmsList[0]
                holder.callSms.text = mAddOnList.callsmsList[1]
            }

        }*/
        Log.d("activeBtn:>>", "onBindViewHolder:${mAddOnList.activateBtn}")
        if (canSubscribe && mAddOnList.activateBtn)
            holder.mActivate.visibility = View.VISIBLE
        holder.btnActivate.setOnClickListener {
            /* val delay = mAddOnList.validityDate
             val separated: List<String> = delay.split(" ")*/
            when {
                // getMainPhoneLogin.isEmpty() -> LoginActivity.lunch(context)
                canSubscribe -> productServiceListener.confirmBuy(
                    mAddOnList.validityDate,
                    mAddOnList.valuePrice,
                    mAddOnList.priceChange, mAddOnList.code,
                    true
                )
            }
        }

    }

    override fun getItemCount(): Int {
        return addOnList.size
    }
}