package com.seatel.mobilehall.ui.home.adapter

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.os.Build
import android.view.LayoutInflater
import android.view.MotionEvent
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageButton
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.model.BuyTopUpCartModel
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.CustomEditText
import java.text.DecimalFormat

class BuyTopUpCardAdapter(private val mContext: Context, private val buyTopUpCartModels: ArrayList<BuyTopUpCartModel>
, private val showCustomKeyBoard: ShowCustomKeyBoard? = null)

    : RecyclerView.Adapter<BuyTopUpCardAdapter.ViewHolder>() {
    var onItemViewClick: OnItemViewClick? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BuyTopUpCardAdapter.ViewHolder {
        return ViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_buy_top_up_card, parent, false))
    }

    @SuppressLint("ResourceAsColor", "ResourceType")
    override fun onBindViewHolder(holder: BuyTopUpCardAdapter.ViewHolder, position: Int) {
        val buyTopUpCartModel = buyTopUpCartModels[position]
        //holder.price.text = buyTopUpCartModel.price.toString()
//        val formatter = NumberFormat.getCurrencyInstance()
//        formatter.format(buyTopUpCartModel.price)

        var df = DecimalFormat()
        df.isDecimalSeparatorAlwaysShown = true
        df = DecimalFormat("#,###")
        holder.price.text = df.format(buyTopUpCartModel.price)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            holder.orderQty.showSoftInputOnFocus = false
        }
        holder.orderQty.setOnTouchListener { _: View, m: MotionEvent ->
            if (m.action == MotionEvent.ACTION_DOWN) {
                holder.orderQty.requestFocus()
                if(showCustomKeyBoard != null)
                    showCustomKeyBoard.focusOnEditText(holder.orderQty)
            }
            false
        }

        holder.orderQty.setOnFocusChangeListener { _, hasFocus ->
            if (!hasFocus && holder.orderQty.text.toString().isNotEmpty()) {
                if (holder.orderQty.text.toString().toInt() > 0)
                    buyTopUpCartModel.order = holder.orderQty.text.toString().toInt()
                else{
                    buyTopUpCartModel.order = 1
                    holder.orderQty.setText(buyTopUpCartModel.order.toString())
                }
            } else if (!hasFocus && holder.orderQty.text.toString().isEmpty()) {
                buyTopUpCartModel.order = 1
                holder.orderQty.setText(buyTopUpCartModel.order.toString())
            }
        }

        holder.orderQty.setText(buyTopUpCartModel.order.toString())
        holder.buttonPlus.setOnClickListener {
            hideCustomKey(holder)
            SeatelUtils.hideKeyboard(mContext as Activity)
            buyTopUpCartModel.order++
            holder.orderQty.setText(buyTopUpCartModel.order.toString())
        }
        holder.buttonMinus.setOnClickListener {
            hideCustomKey(holder)
            SeatelUtils.hideKeyboard(mContext as Activity)
            if (buyTopUpCartModel.order > 1) {
                buyTopUpCartModel.order--
            }
            holder.orderQty.setText(buyTopUpCartModel.order.toString())
        }
        holder.itemView.setOnClickListener {
            hideCustomKey(holder)
            SeatelUtils.hideKeyboard(mContext as Activity)
        }
        holder.buttonAddToCart.setOnClickListener {
            hideCustomKey(holder)
            SeatelUtils.hideKeyboard(mContext as Activity)
            onItemViewClick?.onAddCartClick(holder.adapterPosition, buyTopUpCartModel)

        }
        holder.buyNow.setOnClickListener {
            hideCustomKey(holder)
            SeatelUtils.hideKeyboard(mContext as Activity)
            onItemViewClick?.onBuyNowClick(holder.adapterPosition, buyTopUpCartModel)
        }

    }

    private fun hideCustomKey(holder: BuyTopUpCardAdapter.ViewHolder) {
        if(showCustomKeyBoard != null)
            showCustomKeyBoard.hideKeyBoard()
        holder.orderQty.clearFocus()
    }


    override fun getItemCount(): Int {
        return buyTopUpCartModels.size
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val price: TextView = itemView.findViewById(R.id.text_view_cart_price_top_up)
        val buttonAddToCart: Button = itemView.findViewById(R.id.button_top_up_add_to_cart)
        val buttonPlus: ImageButton = itemView.findViewById(R.id.button_plus)
        val buttonMinus: ImageButton = itemView.findViewById(R.id.button_minus)
        val orderQty: CustomEditText = itemView.findViewById(R.id.text_view_order_qty)
        val buyNow: Button = itemView.findViewById(R.id.button_top_up_buy_now)
    }

    interface OnItemViewClick {
        fun onAddCartClick(position: Int, data: BuyTopUpCartModel)
        fun onBuyNowClick(position: Int, data: BuyTopUpCartModel) {}
    }

    interface ShowCustomKeyBoard {
        fun focusOnEditText(edit: CustomEditText)
        fun hideKeyBoard()
    }
}
