package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.interactor.MyOrderInteractor
import com.seatel.mobilehall.ui.home.model.MyOrderListModel
import com.seatel.mobilehall.ui.home.viewholder.MyOrderMainRowViewHolder

class AdapterListParentOrder(private var context: Context, private var item1:
ArrayList<MyOrderListModel>, private val isHistory: Boolean, private val mView: MyOrderInteractor.View)
    : RecyclerView.Adapter<MyOrderMainRowViewHolder>() {

    private var isAll: Boolean? = false
    private var isLoaded: Boolean? = true

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MyOrderMainRowViewHolder {
        return MyOrderMainRowViewHolder(context, LayoutInflater.from(context).inflate(R.layout.item_my_order_mian_view, parent, false))
    }

    override fun getItemCount(): Int {
        return item1.size
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    fun clearData() {
        item1 = ArrayList()
    }

    fun getSizeItems(): Int {
        return item1.size
    }

    fun addItems(dataItem: ArrayList<MyOrderListModel>) {
        item1.addAll(dataItem)
        if (dataItem.size == 0) {
            notifyDataSetChanged()
        }
        isAll = dataItem.size == 0
        notifyDataSetChanged()
        notifyItemRangeChanged(itemCount, item1.size)
        setLoaded(false)
    }

    fun setLoaded(loaded: Boolean?) {
        isLoaded = loaded
    }

    fun onScrollEvent(linearLayoutManager: LinearLayoutManager) {

        val lastChild = linearLayoutManager.findLastVisibleItemPosition()
        if (lastChild + 1 >= itemCount - 1 && !isLoaded!! && !isAll!!) {
            mView.onLoadMore()
            isLoaded = true
        }
    }

    override fun onBindViewHolder(holder: MyOrderMainRowViewHolder, position: Int) {
        if (position > 0)
            holder.itemView.setPadding(0, 25, 0, 0)
        else holder.itemView.setPadding(0, 0, 0, 0)

        holder.onBind(item1[position],isHistory,mView)
    }




}

