package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import android.view.View
import com.google.gson.Gson
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivitySuccessBuyDataPackBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils

class SuccessBuyDataPackActivity : BaseActivity<ActivitySuccessBuyDataPackBinding>() {

    private var isValuePack = false
    private var isVipFortune = false
    private var isFortune = false
    private var mDataValuePack: ValuePackTableModel? = null
    private var type: String = ""
    private var data: String = ""
    private var isAddON: Boolean = false
    private var message: String? = null
    override fun getViewBinding(): ActivitySuccessBuyDataPackBinding {
        return ActivitySuccessBuyDataPackBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //    setContentView(R.layout.activity_success_buy_data_pack)
        activityEnterUpAnimation()
        getData()

    }

    private fun getData() {
        type = intent.getStringExtra("TYPE_PLAN").toString()
        data = intent.getStringExtra("DATA").toString()
        isAddON = intent.getBooleanExtra("IS_ADD_ON", false)
        message = intent.getStringExtra("message").toString()
        Log.d("TAG::>>>", "getData: $message")

        if (message.equals("null") || message.isNullOrEmpty()) {
            binding.textViewTo.visibility = View.VISIBLE
            binding.tvAccount.text = getPhoneLogin()
            if (isAddON) binding.textViewTopUp.text = "Buy $type Add On"
            else binding.textViewTopUp.text = "Buy $type"
            binding.textViewTopUpAmount.text = data
        } else {
            binding.textViewTopUp.text = message
        }

        binding.imageViewGoToMain.setOnClickListener {
            gotoMainScreen()
            finish()
        }
    }

    private fun init() {
        binding.imageViewGoToMain.setOnClickListener {
            gotoMainScreen()
            finish()
        }
        if (isValuePack) {
            binding.imgValuePack.visibility = View.VISIBLE
            binding.textViewTopUp.visibility = View.GONE
            binding.ctvSize.visibility = View.GONE
            binding.textViewTopUpAmount.text =
                "${SeatelUtils.displayAmountNoDecial(mDataValuePack?.valuePrice.toString())} = ${
                    SeatelUtils.displayAmountNoDecial(mDataValuePack?.priceChange.toString())
                }"
            binding.textViewTo.text =
                SeatelUtils.translatForDialog(this, getString(R.string.is_now_activate))
            binding.tvAccount.text = SeatelUtils.phoneNumberFormat(getPhoneLogin())

        } else if (isFortune) {
            // binding.textViewTopUp.visibility = View.GONE
            binding.ctvSize.visibility = View.GONE
            binding.textViewTopUp.text = " Buy Fortune Pack"
            binding.textViewTopUpAmount.text =
                "${SeatelUtils.displayAmountNoDecial(mDataValuePack?.valuePrice.toString())} = ${
                    SeatelUtils.displayAmountNoDecial(mDataValuePack?.priceChange.toString())
                }"
            binding.textViewTo.text =
                SeatelUtils.translatForDialog(this, getString(R.string.is_now_activate))
            binding.tvAccount.text = SeatelUtils.phoneNumberFormat(getPhoneLogin())
        } else if (isVipFortune) {
            //  binding.textViewTopUp.visibility = View.GONE
            binding.ctvSize.visibility = View.GONE
            binding.textViewTopUp.text = "Buy VIP Fortune Pack"
            binding.textViewTopUpAmount.text =
                "${SeatelUtils.displayAmountNoDecial(mDataValuePack?.valuePrice.toString())} = ${
                    SeatelUtils.displayAmountNoDecial(mDataValuePack?.priceChange.toString())
                }"
            binding.textViewTo.text =
                SeatelUtils.translatForDialog(this, getString(R.string.is_now_activate))
            binding.tvAccount.text = SeatelUtils.phoneNumberFormat(getPhoneLogin())
        } else {
            val amountTotal = intent.getStringExtra(Constant.SUCCESS_VALUE_TOP)
            if (intent.getBooleanExtra(Constant.LAUNCH_FROM, false)) {
                binding.textViewTopUp.text = getString(R.string.buy_freedom_internet)
                binding.textViewTopUpAmount.text =
                    intent.getStringExtra(Constant.SUCCESS_VALUE_TOP)
            } else {
                if (!TextUtils.isEmpty(amountTotal)) {
                    binding.ctvSize.text = amountTotal!!.takeLast(2)
                    binding.textViewTopUpAmount.text =
                        amountTotal.subSequence(0, amountTotal.length - 2)
                }
            }

            binding.tvAccount.text = intent.getStringExtra(Constant.SUCCESS_VALUE_BOTTOM)
        }
    }

    private fun getDataIntent() {
        if (intent.hasExtra("IS_VALUE_PACK")) isValuePack =
            intent.getBooleanExtra("IS_VALUE_PACK", false)
        if (intent.hasExtra("VALUE_PACK_DATA")) mDataValuePack = Gson().fromJson(
            intent.getStringExtra("VALUE_PACK_DATA"), ValuePackTableModel::class.java
        )
        if (intent.hasExtra("IS_FORTUNE_PACK")) isFortune =
            intent.getBooleanExtra("IS_FORTUNE_PACK", false)
        if (intent.hasExtra("IS_VIP_FORTUNE_PACK")) isVipFortune =
            intent.getBooleanExtra("IS_VIP_FORTUNE_PACK", false)

    }


    override fun onBackPressed() {
        super.onBackPressed()
        activityExitDownAnimation()
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }

    companion object {

        fun launch(context: Context, typePlan: String, data: String, isAddOn: Boolean) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            intent.putExtra("TYPE_PLAN", typePlan)
            intent.putExtra("DATA", data)
            intent.putExtra("IS_ADD_ON", isAddOn)
            context.startActivity(intent)
        }

        fun lunch(context: Context, valueTop: String, valueBottom: String, freedom: Boolean) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            intent.putExtra(Constant.SUCCESS_VALUE_TOP, valueTop)
            intent.putExtra(Constant.SUCCESS_VALUE_BOTTOM, valueBottom)
            intent.putExtra(Constant.LAUNCH_FROM, freedom)
            context.startActivity(intent)
        }

        fun launchSwitchPlan(context: Context, message: String) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            intent.putExtra("message", message)
            context.startActivity(intent)
        }

        fun lunchFromValuePack(
            context: Context,
            dataValuePack: ValuePackTableModel,
            isFortunePlan: Boolean = false,
            isVipFortunePlan: Boolean = false
        ) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            when {
                isFortunePlan -> {
                    intent.putExtra("IS_FORTUNE_PACK", true)
                }

                isVipFortunePlan -> {
                    intent.putExtra("IS_VIP_FORTUNE_PACK", true)
                }

                else -> {
                    intent.putExtra("IS_VALUE_PACK", true)
                }
            }
            intent.putExtra("VALUE_PACK_DATA", Gson().toJson(dataValuePack))
            context.startActivity(intent)
        }
    }
}
