package com.seatel.mobilehall.ui.main

import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.Bundle
import android.util.TypedValue
import android.view.View
import android.widget.FrameLayout
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.navigation.NavController
import androidx.navigation.findNavController
import androidx.navigation.ui.setupWithNavController
import com.google.android.material.bottomnavigation.BottomNavigationView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityMainBinding
import com.seatel.mobilehall.util.SeatelUtils.Companion.translatForDialog
import com.seatel.mobilehall.util.viewBinding

class MainActivity : AppCompatActivity() {

    private val binding by viewBinding(ActivityMainBinding::inflate)

    /*  override fun getViewBinding(): ActivityMainBinding {
          return ActivityMainBinding.inflate(layoutInflater)
      }*/

    private lateinit var navController: NavController
    var yesMember = true

    @RequiresApi(Build.VERSION_CODES.O)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        setupBottomNav()

    }

    @RequiresApi(Build.VERSION_CODES.O)
    private fun setupBottomNav() {
        val navView: BottomNavigationView = binding.navView
        navController = findNavController(R.id.nav_host_fragment_activity_main)
        navView.setupWithNavController(navController)
        navView.itemIconTintList = null


        navView.menu.findItem(R.id.navigation_home).title =
            translatForDialog(this, getString(R.string.nav_home))
        navView.menu.findItem(R.id.navigation_package).title =
            translatForDialog(this, getString(R.string.nav_package))
        navView.menu.findItem(R.id.navigation_usage).title =
            translatForDialog(this, getString(R.string.nav_usage))
        navView.menu.findItem(R.id.navigation_profile).title =
            translatForDialog(this, getString(R.string.nav_profile))


        // Hide text for the "yes member" item
        //val yesMemberMenuItem = navView.menu.findItem(R.id.navigation_yes_member)


        val drawable = if (yesMember) {
            ContextCompat.getDrawable(this, R.drawable.ic_yes_membber_active)
        } else {
            ContextCompat.getDrawable(this, R.drawable.ic_yes_memeber_unactive)
        }

        // Apply color tint to the drawable
        //  drawable?.setTint(ContextCompat.getColor(this, R.color.colorPrimary))
       // yesMemberMenuItem.icon = drawable


//        navView.findViewById<View>(yesMemberMenuItem.itemId)?.let { itemView ->
//
//            itemView.findViewById<View>(com.google.android.material.R.id.text)?.visibility =
//                View.GONE
//            itemView.findViewById<View>(com.google.android.material.R.id.navigation_bar_item_large_label_view)?.visibility =
//                View.GONE
//
//
//            // Customize the icon size if needed
//            val iconView =
//                itemView.findViewById<View>(com.google.android.material.R.id.navigation_bar_item_icon_view)
//
//
//            val iconViewParams: FrameLayout.LayoutParams =
//                iconView.layoutParams as FrameLayout.LayoutParams
//            iconViewParams.width = TypedValue.applyDimension(
//                TypedValue.COMPLEX_UNIT_DIP, 40F, resources.displayMetrics
//            ).toInt()
//            iconViewParams.height = TypedValue.applyDimension(
//                TypedValue.COMPLEX_UNIT_DIP, 40F, resources.displayMetrics
//            ).toInt()
//            iconView.layoutParams = iconViewParams
//        }


    }

    /* override fun isDisplayToolbar(): Boolean {
         return false
     }*/


    override fun onBackPressed() {

        when {
            R.id.navigation_home == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_package == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_usage == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_profile == navController.currentDestination?.id -> {
                finish()
            }

            else -> super.onBackPressed()
        }
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, MainActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
            context.startActivity(intent)
        }
    }
}