package com.seatel.mobilehall.util.customview

import android.animation.Animator
import android.animation.ValueAnimator
import android.content.Context
import android.os.Build
import android.text.Html
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewTreeObserver
import android.view.animation.AccelerateDecelerateInterpolator
import android.widget.RelativeLayout
import com.seatel.mobilehall.databinding.ViewInternetPackDetailBinding
import com.seatel.mobilehall.ui.profile.interactor.SubRowListValuePackInteractor
import com.seatel.mobilehall.ui.profile.model.InternetPackListModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import java.text.DecimalFormat
import java.text.DecimalFormatSymbols
import java.util.Locale

@Suppress("DEPRECATION")
class InternetPackDetailView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {

    private var animMove: ValueAnimator? = null
    private var heighViewList: Int = 0
    private var mOnSubListAction: SubRowListValuePackInteractor? = null
    private lateinit var binding: ViewInternetPackDetailBinding

    init {
        // Initialize ViewBinding
        binding = ViewInternetPackDetailBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setActionSubList(action: SubRowListValuePackInteractor) {
        this.mOnSubListAction = action
    }

    fun setDataDisplay(data: InternetPackListModel, isValuePack: Boolean = false) {
        var decimalFormat = DecimalFormat("#.##")
        val typeDataTotal = SeatelUtils.getTypeData(data.remainingData!!)
        var totalRemainingData = SeatelUtils.convertMbToGb(data.remainingData!!)

        // Setting up the data for name and description
        if (data.name != null && data.description != null) {
            binding.tvNameSub.text = data.name
            binding.tvDescriptionSub.text = data.description
        }

        binding.imgArrowSub.visibility = View.GONE
        binding.viewSpotArrow.visibility = View.GONE
        binding.viewSubList.visibility = View.GONE

        binding.textViewExpDate.text = SeatelUtils.getDateTime(
            "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY,
            data.expiredDate
        )
        binding.textViewSubDate.text = SeatelUtils.getDateTime(
            "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY,
            data.subscribedDate
        )

        if (isValuePack) {
            // Customize decimal format for value pack
            val otherSymbols = DecimalFormatSymbols(Locale.getDefault())
            otherSymbols.decimalSeparator = '.'
            otherSymbols.groupingSeparator = ','
            decimalFormat = DecimalFormat("$###,###.##", otherSymbols)
            totalRemainingData = data.remainingData!!

            binding.balanceAmountType.visibility = View.GONE
            binding.tvInternetLeftBottom.visibility = View.INVISIBLE
            binding.viewHeader.visibility = View.VISIBLE

            if (data.exoandable) {
                // Show expandable section
                binding.viewSpotArrow.visibility = View.VISIBLE
                binding.imgArrowSub.visibility = View.VISIBLE

                val str =
                    "${decimalFormat.format(data.listSub!![0].remainingData)}<font color=black textsize=5sp> : ${data.listSub!![0].name}</font>"
                val str2 =
                    "${decimalFormat.format(data.listSub!![1].remainingData)}<font color=black textsize=5sp> : ${data.listSub!![1].name}</font>"

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    binding.tvListRowFirst.text = Html.fromHtml(str, Html.FROM_HTML_MODE_COMPACT)
                    binding.tvListRowSecond.text = Html.fromHtml(str2, Html.FROM_HTML_MODE_COMPACT)
                } else {
                    binding.tvListRowFirst.text = Html.fromHtml(str)
                    binding.tvListRowSecond.text = Html.fromHtml(str2)
                }

                binding.viewSubList.visibility = View.VISIBLE
                binding.viewSubList.viewTreeObserver.addOnGlobalLayoutListener(
                    object : ViewTreeObserver.OnGlobalLayoutListener {
                        override fun onGlobalLayout() {
                            heighViewList = binding.viewSubList.measuredHeight
                            binding.viewSubList.viewTreeObserver.removeOnGlobalLayoutListener(this)
                            binding.viewSubList.visibility = View.GONE
                            mOnSubListAction?.onSetHeightView(heighViewList)
                        }
                    }
                )

                binding.viewSpotArrow.setOnClickListener {
                    binding.viewSpotArrow.isClickable = false
                    if (binding.viewSubList.visibility != View.VISIBLE) {
                        hideShowList(true)
                    } else {
                        hideShowList(false)
                    }
                }
            }
        } else {
            binding.balanceAmountType.text = typeDataTotal
        }
        binding.balanceAmount.text = decimalFormat.format(totalRemainingData)
    }

    private fun hideShowList(isShow: Boolean) {
        animMove = if (isShow) {
            ValueAnimator.ofFloat(180f, 270f)
        } else {
            ValueAnimator.ofFloat(270f, 180f)
        }
        animMove?.addUpdateListener { animation ->
            val animVal = animation.animatedValue as Float
            binding.imgArrowSub.rotation = animVal
        }
        animMove?.addListener(object : Animator.AnimatorListener {
            override fun onAnimationStart(animation: Animator) {}

            override fun onAnimationEnd(animation: Animator) {
                if (!isShow) {
                    binding.viewSubList.visibility = View.GONE
                    binding.imgArrowSub.rotation = 180f
                } else {
                    binding.viewSubList.visibility = View.VISIBLE
                    binding.imgArrowSub.rotation = 270f
                }
                binding.viewSpotArrow.isClickable = true
            }

            override fun onAnimationCancel(animation: Animator) {}

            override fun onAnimationRepeat(animation: Animator) {}
        })
        animMove?.duration = 300
        animMove?.interpolator = AccelerateDecelerateInterpolator()
        animMove?.start()
        mOnSubListAction?.onSubListActionClick(heighViewList, isShow)
    }

}
