package com.seatel.mobilehall.ui.profile.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.profile.interactor.NewPasswordInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject

class NewPasswordPresenter(
    private var mContext: Context,
    private var mSingUpView: NewPasswordInteractor.View
) : NewPasswordInteractor.Presenter {

    override fun onSetNewPassword(phoneNumber: String, oldPassword: String, newPassword: String) {
        postNewPassRequest(phoneNumber, oldPassword, newPassword).setOnErrorListener { error ->
            mSingUpView.onNewPassFailed(error)
        }.setOnResponseListener { _ ->
            mSingUpView.onNewPassSucceed()
        }.execute()
    }

    private fun postNewPassRequest(
        phoneNumber: String,
        oldPassword: String,
        newPassword: String
    ): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return Constant.CHANGE_PASSWORD
            }

            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("oldPassword", oldPassword)
                    data.put("newPassword", newPassword)
                    data.put("phoneNumber", phoneNumber)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

        }
    }
}