package com.seatel.mobilehall.ui.home.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.home.model.PaymentMethodModel;

import java.util.ArrayList;
import java.util.List;

public class OrderPaymentsAdapter extends RecyclerView.Adapter<OrderPaymentsAdapter.MyViewHolder> {

    private final Context mContext;
    private List<PaymentMethodModel> mPaymentMethod = new ArrayList<>();
    private OrderPaymentItemClick mOrderPaymentItemClick;

    public OrderPaymentsAdapter(Context context) {
        this.mContext = context;
    }

    public void setOrderPaymentItemClick(OrderPaymentItemClick orderPaymentItemClick) {
        this.mOrderPaymentItemClick = orderPaymentItemClick;
    }

    public void setDataMethod(List<PaymentMethodModel> paymentMethod) {
        this.mPaymentMethod = paymentMethod;
        notifyDataSetChanged();
    }

    class MyViewHolder extends RecyclerView.ViewHolder {
        private final ImageView imageView;
        private final TextView title;
        private final TextView description;
       // private final ImageView imageViewBig;

        MyViewHolder(View view) {
            super(view);
            imageView = view.findViewById(R.id.img_method);
            title = view.findViewById(R.id.bankTitle);
            description = view.findViewById(R.id.bankDescription);
          //  imageViewBig = view.findViewById(R.id.img_method_big);
        }

    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int position) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_method_payment, parent, false);
        return new MyViewHolder(itemView);
    }


    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, final int position) {
        final PaymentMethodModel data = mPaymentMethod.get(position);
        Glide.with(mContext).load(data.getPaymentIcon()).into(holder.imageView);
        holder.description.setText(data.getDescription());
        holder.title.setText(data.getTitle());
    /*   holder.imageViewBig.setVisibility(View.GONE);
        holder.imageView.setVisibility(View.GONE);
        if (TextUtils.equals(data.getPaymentName(), "aba")) {
      //      holder.imageViewBig.setVisibility(View.VISIBLE);
      //      Glide.with(mContext).load(data.getPaymentIcon()).into(holder.imageViewBig);
        } else {
            holder.imageView.setVisibility(View.VISIBLE);
            Glide.with(mContext).load(data.getPaymentIcon()).into(holder.imageView);
        }
        Glide.with(mContext).load(data.getPaymentIcon()).into(holder.imageView); */
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mOrderPaymentItemClick != null)
                    mOrderPaymentItemClick.onClick(data);
            }
        });
    }

    @Override
    public int getItemCount() {
        return mPaymentMethod.size();
    }

    public interface OrderPaymentItemClick {
        void onClick(PaymentMethodModel data);
    }
}
