package com.seatel.mobilehall.ui.home.viewholder

import android.text.TextUtils
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.model.PlanSubscriptionModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils

/**
 *
 *
 * @author Noel
 * @version
 * @created on 17-Oct-18
 */
class PlanSubscriptionViewHolder(itemView: View) : BaseViewHolder<PlanSubscriptionModel>(itemView) {
    override fun binData(baseRecyclerAdapter: BaseRecyclerAdapter<PlanSubscriptionModel>) {

        val txtPlanSubscription = itemView.findViewById<TextView>(R.id.text_plan_subscription)
        val imgSelected = itemView.findViewById<ImageView>(R.id.image_selected)
        val txtAddOn = itemView.findViewById<TextView>(R.id.text_add_on)
        val txtDefault = itemView.findViewById<TextView>(R.id.text_default)
        val imgPlanIcon = itemView.findViewById<ImageView>(R.id.image_plan_icon)

        val dayStr = SeatelUtils.translatForDialog(itemView.context, "Day")
        val data = baseRecyclerAdapter.getItem(adapterPosition)
        var planName = data.planName
        if (data.isAddOn && data.addOnPrice > 0.0)
            planName = "$planName"
        txtPlanSubscription.text = planName
        imgSelected.visibility = if (data.isSelected) View.VISIBLE else View.GONE
        txtAddOn.visibility =
            if (data.isAddOn && data.isAddOnHeader) View.VISIBLE else View.GONE

        txtDefault.visibility = View.INVISIBLE
        if (data.isAddOn) {
            if (data.addOnPrice > 0.0) {
                txtDefault.visibility = View.VISIBLE
                var str = "(${
                    checkDayStr(
                        dayStr,
                        data.addOnDuraction
                    )
                } = ${
                    SeatelUtils.formatDecimalNumber(
                        data.addOnPrice,
                        "$#.##"
                    )
                })" // String.format(Locale.US, "$%.2f", data.addOnPrice)
                if (data.planCode == Constant.VALUE_PACK)
                    str = "(${
                        SeatelUtils.formatDecimalNumber(
                            data.addOnPrice,
                            "$#.#"
                        )
                    } = ${
                        SeatelUtils.formatDecimalNumber(
                            data.addOnDuraction.toDouble(),
                            "$###,###"
                        )
                    })"
                txtDefault.text = str
            }
        } else {
            txtDefault.visibility = View.VISIBLE
            txtDefault.text = itemView.context.getString(R.string.default_double)
        }
        if (!TextUtils.isEmpty(data.planIcon)) {
            Glide.with(itemView.context).load(data.planIcon).into(imgPlanIcon)
        } else {
            imgPlanIcon.setImageResource(data.icon)
        }
    }

    private fun checkDayStr(strDay: String, dayCount: Int): String {
        return when (SeatelUtils.getLangaugeCode(itemView.context)) {
            Constant.KHMER, Constant.CHINESE -> {
                "$dayCount$strDay"
            }

            else -> {
                "$dayCount-$strDay"
            }
        }
    }
}