package com.seatel.mobilehall.ui.profile.activity

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.application.MyApplication
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.lang.adapter.LanguageAdapter
import com.seatel.mobilehall.ui.lang.interactor.SettingLanguageInteractor
import com.seatel.mobilehall.ui.lang.model.LanguageModel
import com.seatel.mobilehall.ui.main.MainActivity
import com.seatel.mobilehall.ui.profile.interactor.ChangeLanguageInteractor
import com.seatel.mobilehall.ui.profile.presenter.ChangeLanguagePresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.FirebaseAnalyticsUtil
import com.seatel.mobilehall.util.lang.FirstLoginPreference
import com.seatel.mobilehall.util.lang.LanguageManager
import kotlinx.android.synthetic.main.activity_setting_language.*
import java.util.*

class SettingLanguageActivity : BaseActivity(), SettingLanguageInteractor,
    ChangeLanguageInteractor.View {

    private var mSettingLanguageInteractor: SettingLanguageInteractor? = null
    private var mChangeLanguagePresenter: ChangeLanguagePresenter? = null
    private var firstLogin: Boolean = false

    private fun showScreenLogin() {
        activityEnterRightAnimation()
        MainActivity.lunch(this)
        finish()
    }

    override fun onItemLanguageDataClick(languageModel: LanguageModel?) {
        if (languageModel != null) {
            if (!firstLogin) {
                MyApplication.isFirstInstall = true
                FirstLoginPreference.getInstance(this)?.setFirstInstall(true)
                LanguageManager.getInstance(this)
                    .setSelectedLanguage(languageModel.languageCode!!)
                showScreenLogin()
            } else {
                MyApplication.isUpdatedLangauge = true
                // val strCode = LanguageManager.getInstance(this).getLanguageCode()?.toLowerCase()
                val strCode = languageModel.languageCode?.toLowerCase(Locale.getDefault())
                LanguageManager.getInstance(this).setSelectedLanguage(languageModel.languageCode!!)
                if (strCode != null) {
                    if (mChangeLanguagePresenter != null)
                        mChangeLanguagePresenter!!.onPostUpdatedLangauge(getPhoneLogin(), strCode)
                    requestUpdateLanguage(strCode)
                }
                when (strCode) {
                    Constant.KHMER -> //google analytics
                        FirebaseAnalyticsUtil.getInstance(this)
                            .logCustomEvent(Constant.CHOOSE_LANGUAGE_KHMER)
                    Constant.ENGLISH
                    -> //google analytics
                        FirebaseAnalyticsUtil.getInstance(this)
                            .logCustomEvent(Constant.CHOOSE_LANGUAGE_ENGLISH)

                    else -> {
                        FirebaseAnalyticsUtil.getInstance(this)
                            .logCustomEvent(Constant.CHOOSE_LANGUAGE_CHINA)

                    }
                }

                val result = Intent()
                result.putExtra(
                    Constant.LANGUAGE_CHOOSEN_DATA,
                    languageModel.languageCode
                )
                setResult(RESULT_OK, result)
                MainActivity.lunch(this)
            }

        }


    }

    private fun requestUpdateLanguage(code: String) {
        // request for update language
        LanguageManager.getInstance(this).updateResources(this as Activity)
    }

    private fun setSettingLanguageInteractor(mSettingLanguageInteractor: SettingLanguageInteractor) {
        this.mSettingLanguageInteractor = mSettingLanguageInteractor
    }

    override fun onPostUpdatedLangaugeSucceed() {

    }

    override fun onPostUpdatedLangaugeFailed(error: VolleyError) {

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterFadeInAnimation()
        setContentView(R.layout.activity_setting_language)
        init()
    }

    private fun init() {
        firstLogin = FirstLoginPreference.getInstance(this)?.isFirstInstall()!!
        if (firstLogin)
            image_view_device_close.visibility = View.VISIBLE
        mChangeLanguagePresenter = ChangeLanguagePresenter(this, this)

        setSettingLanguageInteractor(this)
        setting_language.layoutManager = LinearLayoutManager(this)
        setting_language.adapter = LanguageAdapter(this, this.mSettingLanguageInteractor)
        image_view_device_close.setOnClickListener { onBackPressed() }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitFadeOutAnimation()
        if (!firstLogin) {
            finish()
        } else
            finish()
    }

    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, SettingLanguageActivity::class.java)
            context.startActivity(intent)
        }

        fun lunch(context: Context, code: Int) {
            val intent = Intent(context, SettingLanguageActivity::class.java)
            (context as Activity).startActivityForResult(intent, code)
        }
    }

    override fun isDisplayBackgroundBlur(): Boolean {
        return true
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }
}
