package com.seatel.mobilehall.ui.login.fragment

import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.login.activity.LoginActivity
import com.seatel.mobilehall.ui.login.interactor.ConfirmSignUpInteractor
import com.seatel.mobilehall.ui.login.presenter.ConfirmSignUpPresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.fragment_login.image_view_back
import kotlinx.android.synthetic.main.fragment_new_password.*
import java.util.*

class NewPasswordFragment : MainFragment(), ConfirmSignUpInteractor.View {

    private var mPhone = ""
    private var mCode = "0"
    private lateinit var mNewPasswordPresenter: ConfirmSignUpPresenter


    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setActivity(context as LoginActivity)
        setFragmentLayout(R.layout.fragment_new_password)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        init()
    }

    private fun init() {
        mNewPasswordPresenter = ConfirmSignUpPresenter(requireContext(), this)

        image_view_back.setOnClickListener { onBackPress() }
        btn_yes.setOnClickListener {
            SeatelUtils.hideKeyboard(getMainActivity())
            startPostNewPassword()
        }

        ctv_password.hint = ctv_password.hint
        ctv_confirm_password.hint = ctv_confirm_password.hint
    }

    fun setDataPost(phone: String, code: String) {
        this.mPhone = phone
        this.mCode = code
    }


    private fun showLoginScreen() {
        getmMainFragmentPresenter()!!.addFragment(LoginFragment(), true)
        SeatelUtils.hideKeyboard(getMainActivity())
    }

    override fun onConfirmSucceed() {

        error_view.visibility = View.GONE
        SeatelAlertDialog.with(requireContext(), getString(R.string.forgot_password_success))
            .setPositiveButton(getString(R.string.yes)) { _, which ->
                //Show Login
                showLoginScreen()
            }.show()


//        // Show Home screen
//        SeatelSharePreferences.getConstant(getmContext()).phoneLogin = mPhone
//        HomeMainActivity.launch(getmContext())
//        getHomeActivity().finish()
//        SeatelUtils.hideKeyboard(getmContext() as HomeActivity)
//        SeatelSharePreferences.getConstant(context).loginSuccess = "true"

    }

    override fun onConfirmFailed(error: VolleyError) {
        error_view.visibility = View.GONE
        val smsError = SeatelSuperRequest.getErrorMessageFrom(error)
        if (smsError.isNotEmpty() && smsError.lowercase(Locale.getDefault())
                .contains("the subscriber is not active")
        )
            SeatelAlertDialog.with(requireContext(), smsError)
                .setPositiveButton(getString(R.string.yes)) { _, _ ->
                    //Show Login
                    showLoginScreen()
                }.show()
        else SeatelUtils.showErrorDialog(requireContext(), smsError)

    }

    private fun validateControl(): Boolean {
        val password = ctv_password.text
        val confirmPassword = ctv_confirm_password.text

        var msg = ""

        if (password!!.isEmpty())
            msg = getString(R.string.new_password_empty)
        else if (confirmPassword!!.isEmpty())
            msg = getString(R.string.confirm_new_password_empty)
        else if (!TextUtils.equals(password, confirmPassword))
            msg = getString(R.string.confirm_new_password_not_match)
        else if (password.length < 6)
            msg = getString(R.string.password_at_least_6_digit)

        if (!TextUtils.isEmpty(msg)) {
            SeatelAlertDialog.with(requireContext(), msg).show()
            return false
        }
        return true
    }

    override fun onDestroy() {
        super.onDestroy()
        mNewPasswordPresenter.onDestroy()
    }

    private fun startPostNewPassword() {
        if (validateControl()) {
            error_view.setViewMode(ErrorHandleView.Mode.LOADING)
            mNewPasswordPresenter.onConfirmCode(
                "v2/",
                mCode,
                "",
                "",
                mPhone,
                ctv_confirm_password.text.toString(),
                "",
                Constant.RESET_PASSWORD
            )
        }
    }

    override fun onBackPress() {
        getmMainFragmentPresenter()!!.addFragment(ForgotPasswordFragment(), true)
        SeatelUtils.hideKeyboard(getMainActivity())
    }


}