package com.seatel.mobilehall.ui.home.fragment


import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.Gravity
import android.view.View
import android.widget.Button
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.adapter.PrefixBottomSheetAdapter
import com.seatel.mobilehall.ui.home.interactor.BuyYesSimCardInteractor
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.manager.OrderingManager
import com.google.android.material.bottomsheet.BottomSheetDialog
import kotlinx.android.synthetic.main.fragment_prefix_number_two.*
import kotlinx.android.synthetic.main.item_buy_yes_number.*


@Suppress("NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS")
class PrefixNumberTwoFragment : BaseBuySimFragment(), BuyYesSimCardInteractor.View {

    private var prefixIntent = "0183"
    private val arrayPrefix = arrayOf("0183", "0184", "0185", "0186", "0187", "0188", "0189")
    private var mBottomSheetDialogPrefix: BottomSheetDialog? = null
    private var isClaimFreeSim: Boolean = false
    private var isWinPromotionFreeSim: Boolean = false
    private var simCardPriceFilter: Int = 0

    companion object {
        fun newInstance(prefixString: String): PrefixNumberTwoFragment {
            val prefix = PrefixNumberTwoFragment()
            val bundle = Bundle()
            bundle.putString(Constant.EXTRA_PREFIX, prefixString)
            prefix.arguments = bundle
            return prefix
        }
    }

    fun setIsWinPromotionFreeSim(winPromotion: Boolean) {
        this.isWinPromotionFreeSim = winPromotion
    }

    fun setSimCardPriceFilter(filter: Int) {
        this.simCardPriceFilter = filter
    }

    fun setClaimFreeSim(claimFree: Boolean) {
        this.isClaimFreeSim = claimFree
    }

    override fun getIsWinPromotionFreeSim(): Boolean {
        return isWinPromotionFreeSim
    }

    override fun getClaimFreeSim(): Boolean {
        return isClaimFreeSim
    }


    override fun initRecyclerView(): RecyclerView {
        return recycler_view_prefix_number_two
    }


    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
          setFragmentLayout(R.layout.fragment_prefix_number_two)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (arguments != null) {
            prefixIntent = requireArguments().getString(Constant.EXTRA_PREFIX).toString()
        }
    }


    override fun init() {
        super.init()
        text_prefix.text = prefixIntent
        if (OrderingManager.getInstance().simPriceDefault == 0.0 || isClaimFreeSim || isWinPromotionFreeSim)
            note.visibility = View.GONE
        if (isClaimFreeSim || isWinPromotionFreeSim) {
            startPrice = simCardPriceFilter
            endPrice = simCardPriceFilter
            layout_show_all.visibility = View.INVISIBLE
        }
        clearDataNotify()
        searchPhoneNumber()
    }

    override fun initEvent() {
        super.initEvent()
        layout_prefix_select.setOnClickListener {
            showBottomSheet()
        }
    }

    private fun showBottomSheet() {
        mBottomSheetDialogPrefix = BottomSheetDialog(requireActivity(), R.style.CustomDialog)
        mBottomSheetDialogPrefix?.window!!.setBackgroundDrawable(
            ColorDrawable(
                ContextCompat.getColor(
                    requireContext(),
                    android.R.color.transparent
                )
            )
        )
        mBottomSheetDialogPrefix?.window!!.setGravity(Gravity.BOTTOM)
        mBottomSheetDialogPrefix?.window!!.setDimAmount(0.5f)
        mBottomSheetDialogPrefix?.window!!.attributes.windowAnimations =
            R.style.DialogAnimationSlideUpDown
        val sheetView =
            requireActivity().layoutInflater.inflate(R.layout.fragment_bottom_sheet, null)
        val recyclerView = sheetView.findViewById<RecyclerView>(R.id.recycler_sim_price)
        val buttonLogin = sheetView.findViewById<Button>(R.id.button_login)
        buttonLogin.setOnClickListener { mBottomSheetDialogPrefix?.dismiss() }
        setSimPriceRecycler(recyclerView)
        mBottomSheetDialogPrefix?.setContentView(sheetView)
        mBottomSheetDialogPrefix?.show()
    }

    private var prefixBottomSheetAdapter: PrefixBottomSheetAdapter? = null
    private fun setSimPriceRecycler(recyclerView: RecyclerView) {
        recyclerView.setHasFixedSize(true)
        recyclerView.layoutManager = LinearLayoutManager(context)
        if (prefixBottomSheetAdapter == null) {
            val mSimPriceModels = arrayPrefix.asList()
            prefixBottomSheetAdapter = PrefixBottomSheetAdapter(mSimPriceModels)
        }
        recyclerView.adapter = prefixBottomSheetAdapter
        prefixBottomSheetAdapter?.onItemClickListener =
            object : BaseRecyclerAdapter.OnItemClickListener<String> {
                override fun onItemClick(v: View, position: Int, data: String) {
                    clearDataNotify()
                    mBottomSheetDialogPrefix?.dismiss()
                    lastSelectModel = null
                    updateUiAfterItemSelected()
                    prefixIntent = data
                    text_prefix.text = data
                    searchPhoneNumber()
                }
            }
    }

    override fun searchPhoneNumber() {
        buyYesSimCardPresenter?.onSearchPhoneNumber(
            requireContext(),
            prefixIntent,
            false,
            startPrice,
            endPrice,
            limit(),
            offset
        )
    }

}
