package com.seatel.mobilehall.ui.mysterybox

import android.content.Context
import android.content.Intent
import android.media.MediaPlayer
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.view.View
import android.view.View.OnClickListener
import com.android.volley.Request
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.CustomGameDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_veaykaorm.anim_bottom
import kotlinx.android.synthetic.main.activity_veaykaorm.anim_middle
import kotlinx.android.synthetic.main.activity_veaykaorm.anim_top
import kotlinx.android.synthetic.main.activity_veaykaorm.btn_first_mystery_box
import kotlinx.android.synthetic.main.activity_veaykaorm.btn_mystery
import kotlinx.android.synthetic.main.activity_veaykaorm.btn_second_mystery_box
import kotlinx.android.synthetic.main.activity_veaykaorm.btn_third_mystery_box
import kotlinx.android.synthetic.main.activity_veaykaorm.img_bottom
import kotlinx.android.synthetic.main.activity_veaykaorm.img_middle
import kotlinx.android.synthetic.main.activity_veaykaorm.img_top
import kotlinx.android.synthetic.main.activity_veaykaorm.view_error
import org.json.JSONObject

class MysteryBoxActivity : BaseActivity(), OnClickListener {

    private var mChance: Int? = null
    private var mLastClickTime: Long = 0
    private var leftClick: Boolean = false
    private var midClick: Boolean = false
    private var rightClick = false
    private lateinit var mp: MediaPlayer


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_veaykaorm)
        btn_second_mystery_box.setOnClickListener(this)
        btn_third_mystery_box.setOnClickListener(this)
        btn_first_mystery_box.setOnClickListener(this)
        btn_mystery.setOnClickListener {
            ValentineRewardActivity.launch(this)
        }
    }

    private fun playSound() {
        //  mp = MediaPlayer.create(this, R.raw.break_kaorm)
        // mp.start()

    }

    private fun mysteryBoxMiddle() {
        img_middle.visibility = View.GONE
        anim_middle.visibility = View.VISIBLE
        anim_middle.playAnimation()
        view_error.setViewMode(ErrorHandleView.Mode.LOADING)
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-angpao/${getPhoneLogin()}/mystery-box"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {

            Handler(Looper.getMainLooper()).postDelayed({
                anim_middle.pauseAnimation()
                img_middle.visibility = View.VISIBLE
                anim_middle.visibility = View.GONE
                view_error.visibility = View.GONE
                val valentineDialog = CustomGameDialog(
                    this, SeatelSuperRequest.getErrorMessageFrom(it), "", "", "", false
                )
                valentineDialog.show()
            }, 500)


        }.execute {
            Handler(Looper.getMainLooper()).postDelayed({
                anim_middle.pauseAnimation()
                view_error.visibility = View.GONE
                img_middle.visibility = View.VISIBLE
                anim_middle.visibility = View.GONE
                val title = (it as JSONObject).optString("title")
                val prize = it.optString("prize")
                val subtitle = it.optString("subtitle")
                val image = it.optString("image")
                val valentineDialog = CustomGameDialog(this, title, prize, subtitle, image, false)
                valentineDialog.show()
            }, 500)

        }


    }

    private fun mysteryBoxTop() {
        img_top.visibility = View.GONE
        anim_top.visibility = View.VISIBLE
        anim_top.playAnimation()
        view_error.setViewMode(ErrorHandleView.Mode.LOADING)
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-angpao/${getPhoneLogin()}/mystery-box"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {

            Handler(Looper.getMainLooper()).postDelayed({
                anim_top.pauseAnimation()
                img_top.visibility = View.VISIBLE
                anim_top.visibility = View.GONE
                view_error.visibility = View.GONE
                val valentineDialog = CustomGameDialog(
                    this, SeatelSuperRequest.getErrorMessageFrom(it), "", "", "", false
                )
                valentineDialog.show()
            }, 500)


        }.execute {
            Handler(Looper.getMainLooper()).postDelayed({
                anim_top.pauseAnimation()
                view_error.visibility = View.GONE
                img_top.visibility = View.VISIBLE
                anim_top.visibility = View.GONE
                val title = (it as JSONObject).optString("title")
                val prize = it.optString("prize")
                val subtitle = it.optString("subtitle")
                val image = it.optString("image")
                val valentineDialog = CustomGameDialog(this, title, prize, subtitle, image, false)
                valentineDialog.show()
            }, 500)

        }


    }

    private fun mysteryBoxBottom() {
        img_bottom.visibility = View.GONE
        anim_bottom.visibility = View.VISIBLE
        anim_bottom.playAnimation()
        view_error.setViewMode(ErrorHandleView.Mode.LOADING)
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-angpao/${getPhoneLogin()}/mystery-box"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {

            Handler(Looper.getMainLooper()).postDelayed({
                anim_bottom.pauseAnimation()
                img_bottom.visibility = View.VISIBLE
                anim_bottom.visibility = View.GONE
                view_error.visibility = View.GONE
                val valentineDialog = CustomGameDialog(
                    this, SeatelSuperRequest.getErrorMessageFrom(it), "", "", "", false
                )
                valentineDialog.show()
            }, 500)


        }.execute {
            Handler(Looper.getMainLooper()).postDelayed({
                anim_bottom.pauseAnimation()
                view_error.visibility = View.GONE
                img_bottom.visibility = View.VISIBLE
                anim_bottom.visibility = View.GONE
                val title = (it as JSONObject).optString("title")
                val prize = it.optString("prize")
                val subtitle = it.optString("subtitle")
                val image = it.optString("image")
                val valentineDialog = CustomGameDialog(this, title, prize, subtitle, image, false)
                valentineDialog.show()
            }, 500)

        }


    }


    /*private fun getChance() {
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-chance/${getPhoneLogin()}/veay-kaorm"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it)).show()
        }.execute {
            mChance = (it as JSONObject).optInt("chance")
        }
    }*/

    private fun vaiLeftKaorm() {/*  btn_mid_kaorm.setOnClickListener {
              midClick = true
              rightClick = false
              btn_right_kaorm.isClickable = false
              btn_left_kaorm.isClickable = false
              btn_left_kaorm.performClick()
          }
          btn_right_kaorm.setOnClickListener {
              rightClick = true
              midClick = false
              btn_mid_kaorm.isClickable = false
              btn_left_kaorm.isClickable = false
              btn_left_kaorm.performClick()
          }

          btn_left_kaorm.setOnClickListener {
              btn_mid_kaorm.isClickable = false
              btn_right_kaorm.isClickable = false
              btn_left_kaorm.isClickable = false
              view_error.setViewMode(ErrorHandleView.Mode.LOADING)
              object : SeatelJSONObjectRequest(this) {
                  override fun getFunctionName(): String {
                      return "v2/seatel/get-angpao/${getPhoneLogin()}/veay-kaorm"
                  }

                  override fun getMethod(): Int {
                      return Request.Method.GET
                  }

              }.setOnErrorListener {
                  view_error.visibility = View.GONE
                  val valentineDialog =
                      ValentineDialog(
                          this,
                          SeatelSuperRequest.getErrorMessageFrom(it),
                          "",
                          "",
                          "",
                          false
                      )
                  valentineDialog.show()
                  Handler(Looper.getMainLooper()).postDelayed({
                      midClick = false
                      rightClick = false
                      btn_right_kaorm.isClickable = true
                      btn_left_kaorm.isClickable = true
                      btn_mid_kaorm.isClickable = true
                  }, 500)


              }.execute {
                  playSound()
                  when {
                      midClick -> {
                          gifMidKaorm.visibility = View.VISIBLE
                          gifRightKaorm.visibility = View.GONE
                          gifLeftKaorm.visibility = View.GONE
                          gifMidKaorm.playAnimation()


                      }
                      rightClick -> {
                          gifMidKaorm.visibility = View.GONE
                          gifRightKaorm.visibility = View.VISIBLE
                          gifLeftKaorm.visibility = View.GONE
                          gifRightKaorm.playAnimation()
                      }

                      else -> {
                          gifMidKaorm.visibility = View.GONE
                          gifRightKaorm.visibility = View.GONE
                          gifLeftKaorm.visibility = View.VISIBLE
                          gifLeftKaorm.playAnimation()

                      }
                  }
                  val title = (it as JSONObject).optString("title")
                  val prize = it.optString("prize")
                  val subtitle = it.optString("subtitle")
                  val image = it.optString("image")

                  Handler(Looper.getMainLooper()).postDelayed({
                      val valentineDialog =
                          ValentineDialog(this, title, prize, subtitle, image, false)
                      valentineDialog.show()
                      view_error.visibility = View.GONE
                      gifLeftKaorm.frame = 0
                      gifRightKaorm.frame = 0
                      gifMidKaorm.frame = 0
                      gifMidKaorm.pauseAnimation()
                      gifRightKaorm.pauseAnimation()
                      gifLeftKaorm.pauseAnimation()
                      mp.reset()
                      Handler(Looper.getMainLooper()).postDelayed({
                          midClick = false
                          rightClick = false
                          btn_right_kaorm.isClickable = true
                          btn_left_kaorm.isClickable = true
                          btn_mid_kaorm.isClickable = true
                      }, 500)
                  }, 1000)
              }


          }*/
    }


    override fun getToolbarTitle(): String {
        return resources.getString(R.string.mystery_box)
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, MysteryBoxActivity::class.java)
            context.startActivity(intent)
        }

    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.btn_first_mystery_box -> mysteryBoxTop()
            R.id.btn_second_mystery_box -> mysteryBoxMiddle()
            R.id.btn_third_mystery_box -> mysteryBoxBottom()
        }
    }
}