package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.activity_top_up_success.*

class TopUpSuccessActivity : BaseActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_top_up_success)
        activityEnterUpAnimation()

        image_view_go_to_main.setOnClickListener {
            //    FirebaseAnalyticsUtil.getInstance(this).logCustomEvent(Constant.SeaTelAnalytics.Value.TOP_UP_PIN_SUCCESS)
            gotoMainScreen()
//            HomeMainActivity.lunch(this)
            finish()
        }

        contentUpdate(intent.getStringExtra(Constant.LAUNCH_FROM).toString())
        val strAmount = intent.getStringExtra(Constant.SUCCESS_VALUE_TOP)!!.replace("$", "")
        text_view_top_up_amount.text = SeatelUtils.displayAmountNoDecial(this, strAmount)
        tv_account.text = intent.getStringExtra(Constant.SUCCESS_VALUE_BOTTOM)

    }

    private fun contentUpdate(typeSuccess: String) {
        when (typeSuccess) {
            Constant.TRANSFER_SUCCESS -> {
                text_view_top_up.text = getString(R.string.transfer)
                text_view_to.text = getString(R.string.to_account)
                img_background_alpha.setImageResource(R.drawable.bg_success_transfer)
            }
            Constant.PAY_CONFIRM -> {
                text_view_top_up.text = getString(R.string.paid)
                text_view_to.text = getString(R.string.to_merchant_id)
                layout_merchant_logo.visibility = View.VISIBLE
                Glide.with(this)
                    .load("https://static1.squarespace.com/static/56ba0fa0859fd0beba37e982/t/57975f2cf5e2317367a08c7f/1469538094231/")
                    .into(img_merchant_logo)
                img_background_alpha.setImageResource(R.drawable.bg_success_paid)

            }
        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitDownAnimation()
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    companion object {
        fun lunch(context: Context, fromScreen: String, valueTop: String, valueBottom: String) {
            val intent = Intent(context, TopUpSuccessActivity::class.java)
            intent.putExtra(Constant.LAUNCH_FROM, fromScreen)
            intent.putExtra(Constant.SUCCESS_VALUE_TOP, valueTop)
            intent.putExtra(Constant.SUCCESS_VALUE_BOTTOM, valueBottom)
            context.startActivity(intent)

        }
    }
}
