package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.view.View
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.application.MyApplication
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.EshopPhaseTwoAdapter
import com.seatel.mobilehall.ui.home.interactor.EShopInteractor
import com.seatel.mobilehall.util.Converter
import kotlinx.android.synthetic.main.activity_eshop_phase_two.*
import kotlinx.android.synthetic.main.item_bottom_eshop.*

@Suppress("UNREACHABLE_CODE")
class EShopPhaseTwoActivity : BaseActivity(), View.OnClickListener, EShopInteractor.View {

    private var cartCount = MyApplication.badgeCartCount
    private val eShop: ArrayList<EshopPhaseTwoAdapter.MenuDataEshop> = ArrayList()
    private var menuAdapter: EshopPhaseTwoAdapter? = null
    private var linearLayoutManager: LinearLayoutManager? = null

    override fun showLoading() {
    }

    enum class ItemEshop {
        SEATEL_SIM_CARD,
        TOPUP_CARD
    }

    override fun hideLoading() {

    }

    override fun onClick(v: View?) {
        MyOrderActivity.lunch(applicationContext)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_eshop_phase_two)
        activityEnterRightAnimation()
        addEShopData()
        text_view_bottom_eshop.text = getString(R.string.view_my_order_eshop)
        text_view_bottom_eshop.setTextColor(ContextCompat.getColor(this, R.color.colorPrimary))
        layout_call_view_my_order.setOnClickListener(this)
        linearLayoutManager = LinearLayoutManager(this)
        recycler_eshop_phase_two.layoutManager = linearLayoutManager
        menuAdapter = EshopPhaseTwoAdapter(this, eShop) {
            showScreenDetail(it)
        }
        recycler_eshop_phase_two.adapter = menuAdapter

    }


    override fun onResume() {
        super.onResume()
        cartCount = MyApplication.badgeCartCount
        invalidateOptionsMenu()

    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        // Inflate the menu; this adds items to the action bar if it is present.
        menuInflater.inflate(R.menu.menu_add_to_cart, menu)
        val menuItem = menu.findItem(R.id.cart_action)
        menuItem.icon = Converter.convertLayoutToImage(
            this@EShopPhaseTwoActivity,
            cartCount,
            R.drawable.ic_eshop_menu
        )
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item.itemId == R.id.cart_action)
            MyCartActivity.launch(applicationContext)
        return super.onOptionsItemSelected(item)
    }


    private fun showScreenDetail(type: ItemEshop) {
        when (type) {
            ItemEshop.SEATEL_SIM_CARD -> BuyYesNumberPhaseTwoActivity.lunch(this)
            ItemEshop.TOPUP_CARD -> BuyTopUpCardActivity.lunch(this)
            //  else -> {}
        }
    }

    private fun addEShopData() {
        eShop.add(
            EshopPhaseTwoAdapter.MenuDataEshop(
                getString(R.string.buy_yes_number),
                R.drawable.ic_sim_card_eshop,
                ItemEshop.SEATEL_SIM_CARD,
                getString(R.string.message_app_guide_ehub_buy_yes)
            )
        )
        eShop.add(
            EshopPhaseTwoAdapter.MenuDataEshop(
                getString(R.string.top_up_card),
                R.drawable.ic_topup_menu,
                ItemEshop.TOPUP_CARD,
                getString(R.string.message_app_guide_ehub_topup)
            )
        )

    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.e_hub)
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, EShopPhaseTwoActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
            context.startActivity(intent)
        }
    }
}
