package com.seatel.mobilehall.ui.main

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.NavController
import androidx.navigation.findNavController
import androidx.navigation.ui.setupWithNavController
import com.google.android.material.bottomnavigation.BottomNavigationView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityMainBinding
import com.seatel.mobilehall.util.SeatelUtils.Companion.translatForDialog
import com.seatel.mobilehall.util.viewBinding
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class

MainActivity : AppCompatActivity() {

    private val binding by viewBinding(
        ActivityMainBinding::inflate
    )

   /* private lateinit var appUpdateManager: AppUpdateManager
    private val updateAvailable = MutableLiveData<Boolean>().apply { value = false }
    private var updateInfo: AppUpdateInfo? = null
    private var updateListener = InstallStateUpdatedListener { state: InstallState ->
        commonLog("update01:$state")
        if (state.installStatus() == InstallStatus.DOWNLOADED) {
            showUpdateSnackbar()
        }
    }
*/
    private lateinit var navController: NavController

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        setupBottomNav()
        /*try {
            appUpdateManager = AppUpdateManagerFactory.create(this)
            appUpdateManager.registerListener(updateListener)
            checkForUpdate()
        } catch (e: Exception) {
            commonLog("update01:Update e1 ${e.message}")
        }*/
    }

    private fun setupBottomNav() {
        val navView: BottomNavigationView = binding.navView
        navController = findNavController(R.id.nav_host_fragment_activity_main)
        navView.setupWithNavController(navController)

        navView.menu.findItem(R.id.navigation_home).title =
            translatForDialog(this, getString(R.string.nav_home))
        navView.menu.findItem(R.id.navigation_package).title =
            translatForDialog(this, getString(R.string.nav_package))
        navView.menu.findItem(R.id.navigation_usage).title =
            translatForDialog(this, getString(R.string.nav_usage))
        navView.menu.findItem(R.id.navigation_profile).title =
            translatForDialog(this, getString(R.string.nav_profile))
    }

    //Check for update availability
   /* private fun checkForUpdate() {
        appUpdateManager.appUpdateInfo.addOnSuccessListener {
            if (it.updateAvailability() == UpdateAvailability.UPDATE_AVAILABLE && it.isUpdateTypeAllowed(
                    AppUpdateType.FLEXIBLE
                )
            ) {
                updateInfo = it
                updateAvailable.value = true
                commonLog("update01:Version code available ${it.availableVersionCode()}")
                startForInAppUpdate(updateInfo)
            } else {
                updateAvailable.value = false
                commonLog("update01:Update not available")
            }
        }
    }

    private fun startForInAppUpdate(it: AppUpdateInfo?) {
        appUpdateManager.startUpdateFlowForResult(it!!, AppUpdateType.FLEXIBLE, this, 1101)
    }

    private fun showUpdateSnackbar() {
        try {
            val snackbar = Snackbar.make(
                binding.container, "An update has just been downloaded.", Snackbar.LENGTH_INDEFINITE
            ).setAction("RESTART") { appUpdateManager.completeUpdate() }
            //snackbar.anchorView = binding.appBarMain.contentMain.bottomNav
            snackbar.setActionTextColor(Color.parseColor("#ffff4444"))
            snackbar.show()
        } catch (e: java.lang.Exception) {
        }
    }

    private fun commonLog(message: String) {
        Log.d("tag001", message)
    }*/

    override fun onBackPressed() {
       /* try {
            appUpdateManager.unregisterListener(updateListener)
        } catch (e: Exception) {
            commonLog("update01:Update e2 ${e.message}")
        }*/
        when {
            R.id.navigation_home == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_package == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_usage == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_profile == navController.currentDestination?.id -> {
                finish()
            }

            else -> super.onBackPressed()
        }
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, MainActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
            context.startActivity(intent)
        }
    }
}