package com.seatel.mobilehall.ui.home.fragment

import android.content.Context
import android.content.Intent
import android.graphics.Color
import android.net.Uri
import android.os.Bundle
import android.text.Spannable
import android.text.SpannableString
import android.text.Spanned
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.view.View
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.adapter.OrderSummaryAdapter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import kotlinx.android.synthetic.main.fragment_order_review_confirm.*
import java.util.*


class OrderReviewConfirmFragment : BaseFragment() {

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setFragmentLayout(R.layout.fragment_order_review_confirm)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val clickableSpan = object : ClickableSpan() {
            override fun onClick(textView: View) {
                val uris = Uri.parse("${BuildConfig.BASE_URL}${Constant.urlTerm}")
                val intents = Intent(Intent.ACTION_VIEW, uris)
                val b = Bundle()
                b.putBoolean("new_window", true)
                intents.putExtras(b)
                if (context != null)
                    context!!.startActivity(intents)
            }
        }
        val strFirst = SeatelUtils.translatForDialog(
            getmContext(),
            getString(R.string.message_confirm_order_terms_policies)
        )
        val strSecond =
            SeatelUtils.translatForDialog(getmContext(), getString(R.string.all_terms_policies))
        val span = SpannableString("$strFirst $strSecond")
        val start = strFirst.length + 1
        val end = start + strSecond.length
        span.setSpan(clickableSpan, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
        span.setSpan(
            ForegroundColorSpan(Color.parseColor("#EC008C")),
            start,
            end,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        ctv_terms_policies.movementMethod = LinkMovementMethod.getInstance()
        ctv_terms_policies.setText(span, TextView.BufferType.SPANNABLE)


        rv_order_review_confirm.layoutManager = LinearLayoutManager(context)
        rv_order_review_confirm.adapter = OrderSummaryAdapter(context)
        tv_total.text =
            String.format(Locale.US, "%.2f", OrderingManager.getInstance().totalSelectedPrice)

        if (OrderingManager.getInstance().deliverStatus == OrderingManager.DeliverStatus.PICKUP) {
            layout_pick_up.visibility = View.VISIBLE
            layout_delivery.visibility = View.GONE
            tv_pick_des.text = ""
            tv_pick_location.text = ""
            if (OrderingManager.getInstance().locationModel != null) {
                tv_pick_des.text = OrderingManager.getInstance().locationModel.address
                tv_pick_location.text = OrderingManager.getInstance().locationModel.name
            }
        } else {
            layout_delivery.visibility = View.VISIBLE
            layout_pick_up.visibility = View.GONE
            tv_delivery_location.text = ""
            if (OrderingManager.getInstance().locationModel != null) {
                tv_delivery_location.text = String.format(
                    Locale.US, "%s\n%s", OrderingManager.getInstance().locationModel.address,
                    OrderingManager.getInstance().locationModel.city
                )
            }
        }
        val nameOrder =
            OrderingManager.getInstance().firstNameSave + " " + OrderingManager.getInstance().lastNameSave
        tv_username.text = if (nameOrder.isEmpty()) "N/A" else nameOrder
        SeatelSharePreferences.getInstance(requireContext())?.setUsername(nameOrder)
        tv_phone.text = SeatelUtils.phoneNumberFormat(OrderingManager.getInstance().phoneNumberSave)
        SeatelSharePreferences.getInstance(requireContext())
            ?.setUserPhone(OrderingManager.getInstance().phoneNumberSave)
        tv_email.text = OrderingManager.getInstance().emailSave
    }
}