package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.interactor.ItemViewInteractor
import kotlinx.android.synthetic.main.item_eshop.view.*

class SupportAdapter(var context: Context, var itemViewInteractor: ItemViewInteractor) :
    BaseAdapter<SupportAdapter.SupportVH>() {

    var dataList = ArrayList<String>()

    init {
        dataList.add(context.getString(R.string.faqs))
        dataList.add(context.getString(R.string.supported_device))
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SupportVH {
        val view = LayoutInflater.from(context).inflate(R.layout.item_eshop, parent, false)
        return SupportVH(view)
    }

    override fun getItemCount(): Int {
        return dataList.size
    }

    override fun onBindViewHolder(holder: SupportVH, position: Int) {

        holder.txtEshopName.text = dataList[position]
        if (position == 0) {
            holder.imgEshop.setImageResource(R.drawable.ic_faq)
        } else
            holder.imgEshop.setImageResource(R.drawable.ic_device_support)

        holder.itemView.visibility = View.INVISIBLE
        setAnimations(holder.itemView, position)

        holder.itemView.setOnClickListener {
            itemViewInteractor.onClick(it, position)
        }
    }

    class SupportVH(item: View) : RecyclerView.ViewHolder(item) {

        val txtEshopName = item.text_eshop_name
        val imgEshop = item.img_eshop

    }


}
