package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.viewholder.CartDeviceViewHolder
import com.seatel.mobilehall.ui.home.viewholder.CartScratchViewHolder
import com.seatel.mobilehall.ui.home.viewholder.CartSimViewHolder
import com.seatel.mobilehall.util.manager.OrderingManager

class OrderSummaryAdapter(context: Context?) : MyCartAdapter(context, null, null, null) {

    override fun onGetData() {

    }

    override fun getItemViewType(position: Int): Int {
        return when (OrderingManager.getInstance().selectedCartsModels[position].type) {
            "device" -> DEVICE
            "sim-card" -> SIM
            else -> SCRATCH
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            DEVICE -> CartDeviceViewHolder(
                LayoutInflater.from(context)
                    .inflate(R.layout.holder_cart_device_item, parent, false)
            )
            SIM -> CartSimViewHolder(
                LayoutInflater.from(context).inflate(R.layout.holder_cart_sim_item, parent, false)
            )
            else -> CartScratchViewHolder(
                LayoutInflater.from(context)
                    .inflate(R.layout.holder_cart_scratch_item, parent, false)
            )
        }
    }

    override fun getItemCount(): Int {
        return OrderingManager.getInstance().selectedCartsModels.size
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is CartDeviceViewHolder -> holder.onBind(OrderingManager.getInstance().selectedCartsModels[position])
            is CartScratchViewHolder -> holder.onBind(OrderingManager.getInstance().selectedCartsModels[position])
            is CartSimViewHolder -> holder.onBind(OrderingManager.getInstance().selectedCartsModels[position])
        }
    }

    companion object {
        const val DEVICE = 0
        const val SIM = 1
        const val SCRATCH = 2
    }
}
