package com.seatel.mobilehall.ui.home.activity


import ProductServiceAdapter
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.google.gson.Gson
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.interactor.AppProductsInteractor
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel
import com.seatel.mobilehall.ui.home.presenter.AppProductsPresenter
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_product_service.*


class ProductServiceActivity : BaseActivity(), AppProductsInteractor.View {

    private val productService: ArrayList<AppProductsResponseModel> = ArrayList()
    private var mAppProductsPresenter: AppProductsPresenter? = null
    var canSubscribe: Boolean = false

    @Override
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_product_service)
        activityEnterRightAnimation()
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        mAppProductsPresenter = AppProductsPresenter(this, this)
        mAppProductsPresenter?.onGetAppProducts(getPhoneLogin())

    }

    private fun setAdapterData() {
        product_service_recycler_view.layoutManager = LinearLayoutManager(this)
        product_service_recycler_view.adapter = ProductServiceAdapter(this, productService) {

            when (it.code) {
                "one-plan" -> {
                    OnePlanDetailActivity.lunch(this)
                }
                "international-call" -> {
                    error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                    InternationalCallDetailActivity.lunch(this)
                }
                "loy-kobs" -> LoyKobActivity.launch(this, it.canSubscribe!!, it.code!!)
                else -> {
                    ProductServiceDetailActivity.launch(
                        this, it.canSubscribe!!, it.code!!, it.name!!

                    )
                }
            }

        }
    }

    override fun onGetAppProductsSucceed(appProductsList: ArrayList<AppProductsResponseModel>) {
        Log.d("---appProduct", "onGetAppProductsSucceed: ${Gson().toJson(appProductsList)}")
        productService.addAll(appProductsList)
        setAdapterData()
        error_view.visibility = View.GONE
    }

    override fun onGetAppProductsFailed(error: VolleyError) {
        when (error) {
            is TimeoutError -> {
                error_view.errorMessage = getString(R.string.connection_timeout)
                error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }
            is NoConnectionError -> {
                error_view.errorMessage = getString(R.string.message_no_internet)
                error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }
            else -> {
                error_view.errorMessage = getString(R.string.no_data)
                error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    override fun onPause() {
        super.onPause()
        error_view.visibility = View.GONE
    }

    override fun onBackPressed() {
        super.onBackPressed()
        error_view.visibility = View.GONE
        activityExitLeftAnimation()
    }

    override fun getToolbarTitle(): String {
        return getString(R.string.product_and_service)
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, ProductServiceActivity::class.java)
            context.startActivity(intent)
        }
    }


}

