package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.adapter.OnePlanHomeDetailAdapter
import com.seatel.mobilehall.ui.home.interactor.OnePlanDetailInteractor
import com.seatel.mobilehall.ui.home.model.OnePlanDetailModel
import com.seatel.mobilehall.ui.home.presenter.OnePlanDetailPresenter
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_data_pack_detail.*

class OnePlanDetailActivity : BaseProductAndServiceActivity(), OnePlanDetailInteractor.View,
    SwipeRefreshLayout.OnRefreshListener {

    private lateinit var onePlanPresenter: OnePlanDetailPresenter

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, OnePlanDetailActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        init()
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.one_plan)
    }

    override fun isShowAddToCardButton(): Boolean {
        return false
    }

    override fun onResponseSucceed(onPlanDetailModel: OnePlanDetailModel) {
        val onePlanDetailAdapter = OnePlanHomeDetailAdapter(this, onPlanDetailModel)
        recycler_view_product_service.adapter = onePlanDetailAdapter
        recycler_view_product_service.layoutManager = LinearLayoutManager(this)
        swipe_refresh_layout.isRefreshing = false
        error_view.visibility = View.GONE
        hideProgress()
    }

    override fun onResponseFailed(error: VolleyError) {
        hideProgress()

        if (error is TimeoutError) {
            error_view.errorMessage = getString(R.string.connection_timeout)
            error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
        } else if (error is NoConnectionError) {
            error_view.errorMessage = getString(R.string.message_no_internet)
            error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
        }
        swipe_refresh_layout.isRefreshing = false
    }

    private fun init() {
        showProgress()
        onePlanPresenter = OnePlanDetailPresenter(this)
        onePlanPresenter.onLoadData()
    }

    override fun onRefresh() {
        onePlanPresenter.onLoadData()
    }
}
