package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.LoyKobAdapter
import com.seatel.mobilehall.ui.home.adapter.LoyKobAddOnAdapter
import com.seatel.mobilehall.ui.home.adapter.TermAndServiceFooterAdapter
import com.seatel.mobilehall.ui.home.interactor.ProductServiceButtonClick
import com.seatel.mobilehall.ui.home.interactor.ProductServiceDetailInteractor
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.ui.home.presenter.ProductServiceDetailPrsenter
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_loykob.*

class LoyKobActivity : BaseActivity(), ProductServiceDetailInteractor.View, View.OnClickListener,
    ProductServiceButtonClick {

    private var mPlanCode: String? = null
    private var canSubscribe: Boolean = false
    private var valueData: String? = null
    private var name: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_loykob)
        activityEnterRightAnimation()
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        getDataIntent()
        init()
    }

    private fun getDataIntent() {
        canSubscribe = intent.getBooleanExtra("CAN_SUBSCRIBE", false)
        mPlanCode = intent.getStringExtra("PLAN_CODE")
    }

    private fun init() {
        ProductServiceDetailPrsenter(this, this).onProServiceDetail(mPlanCode!!,getPhoneLogin())
        btn_benefit.setOnClickListener(this)
        btn_term_condition.setOnClickListener(this)
    }

    override fun onProServiceDetailSucceed(valuePackSectionModel: ValuePackSectionModel) {
        error_view.visibility = View.GONE
        if (valuePackSectionModel.valuePackSecTwoModel.addon.size > 0)
            addon_frame.visibility = View.VISIBLE
        else
            addon_frame.visibility = View.GONE
        valueData = valuePackSectionModel.type
        name = valuePackSectionModel.name
        tv_add_on_term_condition.text = "Add-on Terms & Conditions"
        setupTitle(valuePackSectionModel)
        setupDataList(valuePackSectionModel)
    }

    private fun setupTitle(valuePackSectionModel: ValuePackSectionModel) {

        mainTitle.text = valuePackSectionModel.valuePackSecTwoModel.title
        subTitle.text = valuePackSectionModel.valuePackSecTwoModel.subTitle
    }

    private fun setupDataList(valuePackSectionModel: ValuePackSectionModel) {
        mRecyclerLoyKob.adapter =
            LoyKobAdapter(
                this,
                canSubscribe,
                valuePackSectionModel.valuePackSecTwoModel.table, this, getMainPhoneLogin()
            )

        mRecyclerLoyKobAddOn.apply {
            layoutManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
            adapter = LoyKobAddOnAdapter(
                context,
                canSubscribe,
                valuePackSectionModel.valuePackSecTwoModel.addon,
                this@LoyKobActivity,
                getMainPhoneLogin()
            )
        }
        mRecyclerTermCondition.adapter = TermAndServiceFooterAdapter(
            this, getTermAndServiceEn(valuePackSectionModel.valuePackSecThreeModel.description),
            true
        )

        mRecyclerAddOnTermCondition.adapter = TermAndServiceFooterAdapter(
            this,
            getTermAndServiceEn(valuePackSectionModel.valuePackSecThreeModel.description2),
            true
        )
    }

    private fun getTermAndServiceEn(str: String): List<String> {
        val data = ArrayList<String>()
        data.add(str)
        return data
    }

    override fun onProServiceDetailFailed(error: VolleyError) {
        when (error) {
            is TimeoutError -> {
                error_view.errorMessage = getString(R.string.connection_timeout)
                error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }
            is NoConnectionError -> {
                error_view.errorMessage = getString(R.string.message_no_internet)
                error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }
            else -> {
                error_view.errorMessage = getString(R.string.no_data)
                error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    override fun getToolbarTitle(): String {
        return "Loy Kob"
    }

    override fun onClick(view: View?) {
        when (view?.tag) {
            "BUTTON_BENEFIT" -> {
                frame_benefit.visibility = View.VISIBLE
                btn_benefit.setTextColor(ContextCompat.getColor(this, R.color.colorPrimary))
                btn_benefit.setBackgroundResource(R.drawable.bg_button_cart)
                btn_benefit.isAllCaps = true

                //term condition button
                frame_term_condition.visibility = View.GONE
                btn_term_condition.setTextColor(ContextCompat.getColor(this, R.color.black))
                btn_term_condition.setBackgroundColor(resources.getColor(R.color.colorItemDataPack))

            }
            "BUTTON_TERM_CONDITION" -> {
                frame_term_condition.visibility = View.VISIBLE
                btn_term_condition.setTextColor(ContextCompat.getColor(this, R.color.colorPrimary))
                btn_term_condition.setBackgroundResource(R.drawable.bg_button_cart)
                btn_term_condition.isAllCaps = true

                //Benefit button
                frame_benefit.visibility = View.GONE
                btn_benefit.setTextColor(ContextCompat.getColor(this, R.color.black))
                btn_benefit.setBackgroundColor(resources.getColor(R.color.colorItemDataPack))

            }
        }
    }

    companion object {
        fun launch(
            context: Context, canSubscribe: Boolean, planCode: String
        ) {
            val intent = Intent(context, LoyKobActivity::class.java)
            intent.putExtra("PLAN_CODE", planCode)
            intent.putExtra("CAN_SUBSCRIBE", canSubscribe)
            context.startActivity(intent)
        }

    }

    override fun buttonActive(
        dataValuePack: ValuePackTableModel,
        amountMB: String,
        pricetMB: String,
        account: String,
        dayPlan: Int,
        type: String
    ) {

    }

    override fun confirmBuy(
        validity: String,
        fee: String,
        data: String,
        pricePlanCode: String,
        isAddon: Boolean
    ) {
        when {
            isAddon -> ConfirmBuyDataPackActivity.launch(
                this,
                name!!,
                valueData!!,
                validity,
                fee,
                data,
                pricePlanCode,
                true
            )
            else -> ConfirmBuyDataPackActivity.launch(
                this,
                name!!,
                valueData!!,
                validity,
                fee,
                data,
                pricePlanCode,
                false
            )
        }
    }


}