package com.seatel.mobilehall.data.network.viewmodel

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import com.seatel.mobilehall.data.network.repository.HomeRepository
import com.seatel.mobilehall.ui.home.model.BannersModel
import com.seatel.mobilehall.util.Resource
import kotlinx.coroutines.launch

class HomeViewModel(
    app: Application, private val homeRepository: HomeRepository
) : AndroidViewModel(app) {

    private val _bannerResponse = MutableLiveData<Resource<List<BannersModel>>>()
    val bannersResponse: LiveData<Resource<List<BannersModel>>> = _bannerResponse

    fun fetchBanners(lang: String) = viewModelScope.launch {
        homeRepository.requestBanners(lang).collect {
            _bannerResponse.value = it
        }
    }

}