package com.seatel.mobilehall.data.network.repository

import com.seatel.mobilehall.data.network.BaseApiResponse
import com.seatel.mobilehall.data.network.retrofit.RetrofitInstance
import com.seatel.mobilehall.ui.home.model.BannersModel
import com.seatel.mobilehall.util.Resource
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.flowOn

class HomeRepository : BaseApiResponse() {

    suspend fun getBanners(lang: String) = RetrofitInstance.seatelApi.getBanners(lang)

    suspend fun requestBanners(lang: String): Flow<Resource<List<BannersModel>>> {
        return flow {
            emit(Resource.Loading())
            emit(safeApiCall {
                RetrofitInstance.seatelApi.getBanners(lang)
            })
        }.flowOn(Dispatchers.IO)
    }

}