package com.seatel.mobilehall.ui.home.viewholder

import android.text.TextUtils
import android.view.View
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.model.PlanSubscriptionModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.layout_plan_subscription_item.view.*

/**
 *
 *
 * @author Noel
 * @version
 * @created on 17-Oct-18
 */
class PlanSubscriptionViewHolder(itemView: View) : BaseViewHolder<PlanSubscriptionModel>(itemView) {
    override fun binData(baseRecyclerAdapter: BaseRecyclerAdapter<PlanSubscriptionModel>) {

        var dayStr = SeatelUtils.translatForDialog(itemView.context, "Day")
        val data = baseRecyclerAdapter.getItem(adapterPosition)
        var planName = data.planName
        if (data.isAddOn && data.addOnPrice > 0.0)
            planName = "$planName"
        itemView.text_plan_subscription.text = planName
        itemView.image_selected.visibility = if (data.isSelected) View.VISIBLE else View.GONE
        itemView.text_add_on.visibility =
            if (data.isAddOn && data.isAddOnHeader) View.VISIBLE else View.GONE

        itemView.text_default.visibility = View.INVISIBLE
        if (data.isAddOn) {
            if (data.addOnPrice > 0.0) {
                itemView.text_default.visibility = View.VISIBLE
                var str = "(${
                    checkDayStr(
                        dayStr,
                        data.addOnDuraction
                    )
                } = ${
                    SeatelUtils.formatDecimalNumber(
                        data.addOnPrice,
                        "$#.##"
                    )
                })" // String.format(Locale.US, "$%.2f", data.addOnPrice)
                if (data.planCode == Constant.VALUE_PACK)
                    str = "(${
                        SeatelUtils.formatDecimalNumber(
                            data.addOnPrice,
                            "$#.#"
                        )
                    } = ${
                        SeatelUtils.formatDecimalNumber(
                            data.addOnDuraction.toDouble(),
                            "$###,###"
                        )
                    })"
                itemView.text_default.text = str
            }
        } else {
            itemView.text_default.visibility = View.VISIBLE
            itemView.text_default.text = itemView.context.getString(R.string.default_double)
        }
        if (!TextUtils.isEmpty(data.planIcon)) {
            Glide.with(itemView.context).load(data.planIcon).into(itemView.image_plan_icon)
        } else {
            itemView.image_plan_icon.setImageResource(data.icon)
        }
    }

    private fun checkDayStr(strDay: String, dayCount: Int): String {
        return when (SeatelUtils.getLangaugeCode(itemView.context)) {
            Constant.KHMER, Constant.CHINESE -> {
                "$dayCount$strDay"
            }
            else -> {
                "$dayCount-$strDay"
            }
        }
    }
}