package com.seatel.mobilehall.util.customview

import android.animation.Animator
import android.animation.ValueAnimator
import android.content.Context
import android.os.Build
import android.text.Html
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewTreeObserver
import android.view.animation.AccelerateDecelerateInterpolator
import android.widget.RelativeLayout
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.profile.interactor.SubRowListValuePackInteractor
import com.seatel.mobilehall.ui.profile.model.InternetPackListModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.view_internet_pack_detail.view.*
import java.text.DecimalFormat
import java.text.DecimalFormatSymbols
import java.util.*

@Suppress("DEPRECATION")
class InternetPackDetailView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {

    private var animMove: ValueAnimator? = null
    private var heighViewList: Int = 0
    private var mOnSubListAction: SubRowListValuePackInteractor? = null

    init {
        LayoutInflater.from(context).inflate(R.layout.view_internet_pack_detail, this)
    }

    fun setActionSubList(action: SubRowListValuePackInteractor) {
        this.mOnSubListAction = action
    }

    fun setDataDisplay(data: InternetPackListModel, isValuePack: Boolean = false) {
        var decimalFormat = DecimalFormat("#.##")
        val typeDataTotal = SeatelUtils.getTypeData(data.remainingData!!)
        var totalRemainingData = SeatelUtils.convertMbToGb(data.remainingData!!)
        if (data.name != null && data.description != null) {
            tv_name_sub.text = data.name
            tv_description_sub.text = data.description
        }

        img_arrow_sub.visibility = View.GONE
        view_spot_arrow.visibility = View.GONE
        view_sub_list.visibility = View.GONE

        text_view_exp_date.text = SeatelUtils.getDateTime(
            "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY,
            data.expiredDate
        )
        text_view_sub_date.text = SeatelUtils.getDateTime(
            "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY,
            data.subscribedDate
        )
        if (isValuePack) {
            val otherSymbols = DecimalFormatSymbols(Locale.getDefault())
            otherSymbols.decimalSeparator = '.'
            otherSymbols.groupingSeparator = ','
            decimalFormat = DecimalFormat("$###,###.##", otherSymbols)
            totalRemainingData = data.remainingData!!
            balance_amount_type.visibility = View.GONE
            tv_internet_left_bottom.visibility = View.INVISIBLE
            view_header.visibility = View.VISIBLE

            if (data.exoandable) {
                view_spot_arrow.visibility = View.VISIBLE
                img_arrow_sub.visibility = View.VISIBLE

                val str =
                    "${decimalFormat.format(data.listSub!![0].remainingData)}<font color=black textsize=5sp> : ${data.listSub!![0].name}</font>"
                val str2 =
                    "${decimalFormat.format(data.listSub!![1].remainingData)}<font color=black textsize=5sp> : ${data.listSub!![1].name}</font>"
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    tv_list_row_first.text = Html.fromHtml(str, Html.FROM_HTML_MODE_COMPACT)
                    tv_list_row_second.text = Html.fromHtml(str2, Html.FROM_HTML_MODE_COMPACT)
                } else {
                    tv_list_row_first.text = Html.fromHtml(str)
                    tv_list_row_second.text = Html.fromHtml(str2)
                }
                view_sub_list.visibility = View.VISIBLE
                view_sub_list.viewTreeObserver.addOnGlobalLayoutListener(
                    object : ViewTreeObserver.OnGlobalLayoutListener {
                        override fun onGlobalLayout() {
                            heighViewList = view_sub_list.measuredHeight
                            view_sub_list.viewTreeObserver.removeOnGlobalLayoutListener(this)
                            view_sub_list.visibility = View.GONE
                            mOnSubListAction?.onSetHeightView(heighViewList)
                        }
                    }
                )

                view_spot_arrow.setOnClickListener {
                    view_spot_arrow.isClickable = false
                    if (view_sub_list.visibility != View.VISIBLE) {
                        hideShowList(true)
                    } else {
                        hideShowList(false)
                    }
                }
            }
        } else {
            balance_amount_type.text = typeDataTotal
        }
        balance_amount.text = decimalFormat.format(totalRemainingData)
    }

    private fun hideShowList(isShow: Boolean) {
        animMove = if (isShow) {
            ValueAnimator.ofFloat(180f, 270f)
        } else {
            ValueAnimator.ofFloat(270f, 180f)
        }
        animMove?.addUpdateListener { animation ->
            val animVal = animation.animatedValue as Float
            img_arrow_sub.rotation = animVal
        }
        animMove?.addListener(object : Animator.AnimatorListener {
            override fun onAnimationStart(animation: Animator) {}

            override fun onAnimationEnd(animation: Animator) {
                if (!isShow) {
                    view_sub_list.visibility = View.GONE
                    img_arrow_sub.rotation = 180f
                } else {
                    view_sub_list.visibility = View.VISIBLE
                    img_arrow_sub.rotation = 270f
                }
                view_spot_arrow.isClickable = true
            }

            override fun onAnimationCancel(animation: Animator) {}

            override fun onAnimationRepeat(animation: Animator) {}
        })
        animMove?.duration = 300
        animMove?.interpolator = AccelerateDecelerateInterpolator()
        animMove?.start()
        mOnSubListAction?.onSubListActionClick(heighViewList, isShow)
    }

}