package com.seatel.mobilehall.ui.usage

import android.content.Context
import android.os.Build
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.RequiresApi
import androidx.viewpager.widget.ViewPager
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.databinding.FragmentUsageBinding
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.main.MainActivity
import com.seatel.mobilehall.ui.usage.adapter.UsageAdapter
import com.seatel.mobilehall.ui.usage.fragement.InternetFragment
import com.seatel.mobilehall.ui.usage.fragement.SMSFragment
import com.seatel.mobilehall.ui.usage.fragement.VoiceFragment
import com.seatel.mobilehall.util.viewFragmentBinding
import kotlinx.android.synthetic.main.fragment_usage.*
import java.text.SimpleDateFormat
import java.util.*

class UsageFragment : BaseFragment() {


    private val binding by viewFragmentBinding(
        FragmentUsageBinding::inflate
    )

    private var mVoiceFragment: VoiceFragment? = null
    private var mSmsFragment: SMSFragment? = null
    private var mInternetFragment: InternetFragment? = null
    private var calendarFilterFrom: Calendar? = null
    private var calendarFilterTo: Calendar? = null
    private var defaultCurrentIndex = 0
    private var mStartData = ""
    private var mEndData = ""
    private lateinit var mUsageAdapter: UsageAdapter

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        //  setFragmentLayout(R.layout.fragment_usage)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        init()
        setupTabLayout()
        return binding.root
    }

    /* override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
         super.onViewCreated(view, savedInstanceState)

     }
 */
    private fun init() {
        calendarFilterFrom = Calendar.getInstance()
        calendarFilterTo = Calendar.getInstance()
        if (mStartData.isEmpty()) {
            val sdf = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
            mStartData = sdf.format(Date())
            mEndData = sdf.format(Date())
        }
    }


    private fun setupTabLayout() {
        binding.tabLayoutBilling.setupWithViewPager(binding.viewpagerBilling)

        binding.titleBilling.text = getString(R.string.voice)
        binding.titleBilling
        val strVoice = binding.titleBilling.text

        binding.titleBilling.text = getString(R.string.internet)
        val strInternet = binding.titleBilling.text

        binding.titleBilling.text = getString(R.string.sms)
        val strSms = binding.titleBilling.text

        mUsageAdapter = UsageAdapter(childFragmentManager)
        mVoiceFragment = VoiceFragment()
        mVoiceFragment?.setPhoneNuber(getPhoneLogin())

        mInternetFragment = InternetFragment()
        mInternetFragment?.setPhoneNuber(getPhoneLogin())

        mSmsFragment = SMSFragment()
        mSmsFragment?.setPhoneNuber(getPhoneLogin())

        mUsageAdapter.addFragment(mInternetFragment!!, strInternet as String)
        mUsageAdapter.addFragment(mVoiceFragment!!, strVoice as String)
        mUsageAdapter.addFragment(mSmsFragment!!, strSms as String)


        binding.viewpagerBilling.adapter = mUsageAdapter

        binding.viewpagerBilling.offscreenPageLimit = 3
        binding.viewpagerBilling.currentItem = defaultCurrentIndex

        binding.viewpagerBilling.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
            override fun onPageScrolled(
                position: Int, positionOffset: Float, positionOffsetPixels: Int
            ) {
            }

            override fun onPageSelected(position: Int) {}

            @RequiresApi(Build.VERSION_CODES.M)
            override fun onPageScrollStateChanged(state: Int) {
                if (ViewPager.SCROLL_STATE_IDLE == state) {
                    defaultCurrentIndex = binding.viewpagerBilling.currentItem
                    //Scrolling finished. Do something.

                }
            }
        })

    }


}