package com.seatel.mobilehall.ui.profile.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.BottomAccountChooserDialog
import kotlinx.android.synthetic.main.holder_dialog_choose_account_item.view.*

class BottomAccountChooserAdapter :
    RecyclerView.Adapter<BottomAccountChooserAdapter.BottomChooserViewHolder>() {
    private var bottomChooserModels =
        ArrayList<BottomAccountChooserDialog.BottomAccountChooserModel>()
    private var onItemClick: OnItemClick? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BottomChooserViewHolder {
        return BottomChooserViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.holder_dialog_choose_account_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return bottomChooserModels.size
    }

    override fun onBindViewHolder(holder: BottomChooserViewHolder, position: Int) {
        holder.itemView.tv_chooser.text = bottomChooserModels[position].name

        holder.itemView.tv_plus.visibility = View.GONE
        holder.itemView.view_line.visibility = View.VISIBLE
        if (position == 0)
            holder.itemView.view_line.visibility = View.GONE

        if (position == bottomChooserModels.size - 1)
            holder.itemView.tv_plus.visibility = View.VISIBLE

        holder.itemView.deleted_number.visibility = View.GONE
        if (bottomChooserModels[position].deleted)
            holder.itemView.deleted_number.visibility = View.VISIBLE

        holder.itemView.setOnClickListener {
            onItemClick?.onClick(position, bottomChooserModels[position])
        }
        holder.itemView.deleted_number.setOnClickListener {
            onItemClick?.onDelete(position, bottomChooserModels[position])
        }
    }

    interface OnItemClick {
        fun onClick(position: Int, data: BottomAccountChooserDialog.BottomAccountChooserModel)
        fun onDelete(position: Int, data: BottomAccountChooserDialog.BottomAccountChooserModel)
    }

    fun addItems(
        bottomChooserModels: ArrayList<BottomAccountChooserDialog.BottomAccountChooserModel>,
        onItemClick: OnItemClick
    ) {
        this.onItemClick = onItemClick
        this.bottomChooserModels.clear()
        this.bottomChooserModels.addAll(bottomChooserModels)
    }

    class BottomChooserViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView)
}