package com.seatel.mobilehall.ui.home.viewholder

import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.activity.OrderActivity
import com.seatel.mobilehall.ui.home.model.CartModel
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import kotlinx.android.synthetic.main.holder_cart_scratch_item.view.*
import java.util.*

class CartScratchViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

    fun onBind(data: CartModel) {
        itemView.tv_scratch_price.text = String.format(Locale.US, "$%.2f", data.unitPrice)
        itemView.tv_total.text = String.format(Locale.US, "%.2f", data.quantity * data.unitPrice)
        itemView.tv_scratch_amount.text = String.format(Locale.US, "$%.2f", data.scratchCardAmount)
        itemView.tv_scratch_qty.text = String.format(Locale.US, "%d", data.quantity)
        itemView.check_box.isChecked = data.isSelected

        if (TextUtils.isEmpty(data.scratchCardIcon))
            itemView.scratch_image.setImageResource(R.drawable.ic_scratch_card)
        else
            Glide.with(itemView.context).load(data.scratchCardIcon).into(itemView.scratch_image)

        if (itemView.context is OrderActivity) {
            itemView.layout_total.visibility = View.GONE
            itemView.check_box.visibility = View.GONE
            itemView.image_view_remove.visibility = View.GONE
            itemView.image_view_add.visibility = View.GONE
            itemView.tv_scratch_qty.background = null
            itemView.tv_scratch_qty.setPadding(0, 0, 0, 0)
        } else {
            val param = FrameLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
            param.topMargin = SeatelUtils.convertDpToPx(itemView.context, 10)
//            param.bottomMargin = if (adapterPosition == count - 1 && (itemView.context as MyCartActivity).getBottomBar().visibility == View.VISIBLE)
//                (itemView.context as MyCartActivity).getBottomBar().height + 0 else 0
            itemView.layoutParams = param
        }

        itemView.image_view_remove.setOnClickListener {
            OrderingManager.getInstance().updateCartItem(itemView.context, data, data.quantity - 1)
        }
        itemView.image_view_add.setOnClickListener {
            OrderingManager.getInstance().updateCartItem(itemView.context, data, data.quantity + 1)
        }
    }
}